/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.web.servlet.filter;

import com.taotao.cloud.common.context.TraceContextHolder;
import com.taotao.cloud.common.utils.common.IdGeneratorUtils;
import com.taotao.cloud.common.utils.lang.StringUtils;
import com.taotao.cloud.common.utils.servlet.RequestUtils;
import com.taotao.cloud.common.utils.servlet.TraceUtils;
import com.taotao.cloud.web.properties.FilterProperties;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.filter.OncePerRequestFilter;

@WebFilter(filterName="TraceFilter", urlPatterns={"/*"}, asyncSupported=true)
public class TraceFilter
extends OncePerRequestFilter {
    private final FilterProperties filterProperties;

    public TraceFilter(FilterProperties filterProperties) {
        this.filterProperties = filterProperties;
    }

    protected boolean shouldNotFilter(HttpServletRequest request) throws ServletException {
        return RequestUtils.excludeActuator((HttpServletRequest)request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            String traceId = TraceUtils.getTraceId((HttpServletRequest)request);
            if (StringUtils.isBlank((String)traceId)) {
                traceId = IdGeneratorUtils.getIdStr();
            }
            TraceContextHolder.setTraceId((String)traceId);
            TraceUtils.setMdcTraceId((String)traceId);
            TraceUtils.mdcZipkinTraceId((HttpServletRequest)request);
            TraceUtils.mdcZipkinSpanId((HttpServletRequest)request);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            TraceContextHolder.clear();
            TraceUtils.removeMdcTraceId();
            TraceUtils.mdcRemoveZipkinTraceId();
            TraceUtils.mdcRemoveZipkinSpanId();
        }
    }
}

