/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.web.servlet.filter;

import cn.hutool.core.util.StrUtil;
import com.taotao.cloud.common.context.VersionContextHolder;
import com.taotao.cloud.common.utils.servlet.RequestUtils;
import com.taotao.cloud.common.utils.servlet.TraceUtils;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.filter.OncePerRequestFilter;

@WebFilter(filterName="VersionFilter", urlPatterns={"/*"}, asyncSupported=true)
public class VersionFilter
extends OncePerRequestFilter {
    protected boolean shouldNotFilter(HttpServletRequest request) throws ServletException {
        return RequestUtils.excludeActuator((HttpServletRequest)request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        try {
            String version = request.getHeader("taotao-cloud-request-version-header");
            if (StrUtil.isNotEmpty((CharSequence)version)) {
                VersionContextHolder.setVersion((String)version);
                TraceUtils.mdcVersion((String)version);
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            VersionContextHolder.clear();
            TraceUtils.mdcRemoveVersion();
        }
    }
}

