/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.web.strategy;

import com.taotao.cloud.web.strategy.BusinessHandler;
import com.taotao.cloud.web.strategy.HandlerType;
import com.taotao.cloud.web.strategy.HandlerTypeImpl;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.core.annotation.AnnotationUtils;

public class BusinessHandlerChooser {
    private Map<HandlerType, BusinessHandler> businessHandlerMap;

    public void setBusinessHandlerMap(List<BusinessHandler> orderHandlers) {
        this.businessHandlerMap = orderHandlers.stream().filter(Objects::nonNull).collect(Collectors.toMap(orderHandler -> (HandlerType)AnnotationUtils.findAnnotation(orderHandler.getClass(), HandlerType.class), v -> v, (v1, v2) -> v1));
    }

    public <R, T> BusinessHandler businessHandlerChooser(String type, String source) {
        HandlerTypeImpl orderHandlerType = new HandlerTypeImpl(type, source);
        return this.businessHandlerMap.get(orderHandlerType);
    }
}

