/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.web.utils;

import com.taotao.cloud.common.utils.context.ContextUtils;
import com.taotao.cloud.common.utils.log.LogUtils;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.PooledPBEStringEncryptor;
import org.jasypt.encryption.pbe.config.PBEConfig;
import org.jasypt.encryption.pbe.config.SimpleStringPBEConfig;

public class JasyptUtil {
    private static StringEncryptor stringEncryptor = (StringEncryptor)ContextUtils.getBean(StringEncryptor.class, (boolean)true);

    public String encrypt(String content) {
        return stringEncryptor.encrypt(content);
    }

    public String decrypt(String content) {
        return stringEncryptor.decrypt(content);
    }

    public static StringEncryptor getInstance(String password) throws Exception {
        if (password == null || "".equals(password.trim())) {
            LogUtils.error((String)"\u79d8\u94a5\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            throw new Exception("org.jasypt.encryption.StringEncryptor\u79d8\u94a5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (stringEncryptor == null) {
            PooledPBEStringEncryptor encryptor = new PooledPBEStringEncryptor();
            SimpleStringPBEConfig config = new SimpleStringPBEConfig();
            config.setPassword(password);
            config.setAlgorithm("PBEWITHHMACSHA512ANDAES_256");
            config.setKeyObtentionIterations("1000");
            config.setPoolSize("1");
            config.setProviderName("SunJCE");
            config.setSaltGeneratorClassName("org.jasypt.salt.RandomSaltGenerator");
            config.setIvGeneratorClassName("org.jasypt.iv.RandomIvGenerator");
            config.setStringOutputType("base64");
            encryptor.setConfig((PBEConfig)config);
            stringEncryptor = encryptor;
        }
        return stringEncryptor;
    }

    static {
        if (stringEncryptor == null) {
            try {
                String password = ContextUtils.getApplicationContext().getEnvironment().getProperty("jasypt.encryptor.password", "taotao-cloud");
                stringEncryptor = JasyptUtil.getInstance(password);
            }
            catch (Exception e) {
                LogUtils.error((Throwable)e);
            }
        }
    }
}

