/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.web.validation.converter;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.taotao.cloud.common.enums.BaseEnum;
import java.util.Map;
import org.springframework.core.convert.converter.Converter;

public class StringToEnumConverter<T extends BaseEnum>
implements Converter<String, T> {
    private final Map<String, T> enumMap = MapUtil.newHashMap();

    public StringToEnumConverter(Class<T> enumType) {
        BaseEnum[] enums;
        for (BaseEnum e : enums = (BaseEnum[])enumType.getEnumConstants()) {
            Integer code = e.getCode();
            this.enumMap.put(e.getNameByCode(code.intValue()), e);
        }
    }

    public T convert(String source) {
        BaseEnum t = (BaseEnum)this.enumMap.get(source);
        if (ObjectUtil.isNull((Object)t)) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u5339\u914d\u5bf9\u5e94\u7684\u7c7b\u578b");
        }
        return (T)t;
    }
}

