/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.websocket.configuration;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.websocket.interceptor.WebSocketChannelInterceptor;
import com.taotao.cloud.websocket.interceptor.WebSocketHandshakeHandler;
import com.taotao.cloud.websocket.processor.WebSocketClusterProcessor;
import com.taotao.cloud.websocket.processor.WebSocketMessageSender;
import com.taotao.cloud.websocket.properties.WebSocketProperties;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.messaging.simp.config.ChannelRegistration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.messaging.simp.user.SimpUserRegistry;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.web.socket.config.annotation.DelegatingWebSocketMessageBrokerConfiguration;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketTransportRegistration;
import org.springframework.web.socket.server.HandshakeHandler;

@AutoConfiguration(after={DelegatingWebSocketMessageBrokerConfiguration.class})
@EnableWebSocketMessageBroker
@ConditionalOnBean(value={RedissonClient.class})
@EnableConfigurationProperties(value={WebSocketProperties.class})
@ConditionalOnProperty(prefix="taotao.cloud.websocket", name={"enabled"}, havingValue="true")
public class WebSocketAutoConfiguration
implements WebSocketMessageBrokerConfigurer,
InitializingBean {
    @Autowired
    private WebSocketProperties webSocketProperties;
    @Autowired
    private SimpUserRegistry simpUserRegistry;
    @Autowired
    private RedissonClient redissonClient;

    public void afterPropertiesSet() throws Exception {
        LogUtils.started(WebSocketAutoConfiguration.class, (String)"taotao-cloud-starter-websocket", (String[])new String[0]);
    }

    @PostConstruct
    public void postConstruct() {
        LogUtils.info((String)"Plugin [WebSocket] Auto Configure.", (Object[])new Object[0]);
    }

    @Bean
    public WebSocketChannelInterceptor webSocketChannelInterceptor() {
        WebSocketChannelInterceptor webSocketChannelInterceptor = new WebSocketChannelInterceptor();
        webSocketChannelInterceptor.setWebSocketProperties(this.webSocketProperties);
        LogUtils.info((String)"Bean [Web Socket Inbound Channel Interceptor] Auto Configure.", (Object[])new Object[0]);
        return webSocketChannelInterceptor;
    }

    @Bean
    public WebSocketHandshakeHandler webSocketHandshakeHandler() {
        WebSocketHandshakeHandler webSocketHandshakeHandler = new WebSocketHandshakeHandler();
        webSocketHandshakeHandler.setWebSocketProperties(this.webSocketProperties);
        LogUtils.info((String)"Bean [Web Socket Handshake Handler] Auto Configure.", (Object[])new Object[0]);
        return webSocketHandshakeHandler;
    }

    @Bean
    public WebSocketMessageSender webSocketMessageSender(SimpMessagingTemplate simpMessagingTemplate) {
        WebSocketMessageSender webSocketMessageSender = new WebSocketMessageSender();
        webSocketMessageSender.setSimpMessagingTemplate(simpMessagingTemplate);
        webSocketMessageSender.setSimpUserRegistry(this.simpUserRegistry);
        webSocketMessageSender.setWebSocketProperties(this.webSocketProperties);
        LogUtils.info((String)"Bean [Web Socket Message Sender] Auto Configure.", (Object[])new Object[0]);
        return webSocketMessageSender;
    }

    @Bean
    public WebSocketClusterProcessor webSocketClusterProcessor(WebSocketMessageSender webSocketMessageSender) {
        WebSocketClusterProcessor webSocketClusterProcessor = new WebSocketClusterProcessor();
        webSocketClusterProcessor.setWebSocketProperties(this.webSocketProperties);
        webSocketClusterProcessor.setWebSocketMessageSender(webSocketMessageSender);
        webSocketClusterProcessor.setRedissonClient(this.redissonClient);
        LogUtils.info((String)"Bean [Web Socket Cluster Processor] Auto Configure.", (Object[])new Object[0]);
        return webSocketClusterProcessor;
    }

    public void registerStompEndpoints(StompEndpointRegistry registry) {
        registry.addEndpoint(new String[]{this.webSocketProperties.getEndpoint()}).setAllowedOriginPatterns(new String[]{"*"}).setHandshakeHandler((HandshakeHandler)this.webSocketHandshakeHandler()).withSockJS();
    }

    public void configureMessageBroker(MessageBrokerRegistry registry) {
        ThreadPoolTaskScheduler taskScheduler = new ThreadPoolTaskScheduler();
        taskScheduler.setPoolSize(1);
        taskScheduler.setThreadNamePrefix("taotao-cloud-websocket-heartbeat-thread-");
        taskScheduler.initialize();
        registry.enableSimpleBroker(new String[]{this.webSocketProperties.getBroadcast(), this.webSocketProperties.getPeerToPeer()});
        Object[] applicationDestinationPrefixes = this.webSocketProperties.getApplicationPrefixes();
        if (ArrayUtils.isNotEmpty((Object[])applicationDestinationPrefixes)) {
            registry.setApplicationDestinationPrefixes((String[])applicationDestinationPrefixes);
        }
        if (StringUtils.isNotBlank((CharSequence)this.webSocketProperties.getUserDestinationPrefix())) {
            registry.setUserDestinationPrefix(this.webSocketProperties.getUserDestinationPrefix());
        }
    }

    public void configureWebSocketTransport(WebSocketTransportRegistration registration) {
        registration.setMessageSizeLimit(10240).setSendBufferSizeLimit(10240).setSendTimeLimit(10000);
    }

    public void configureClientInboundChannel(ChannelRegistration registration) {
        registration.taskExecutor().corePoolSize(10).maxPoolSize(20).keepAliveSeconds(60);
        registration.interceptors(new ChannelInterceptor[]{this.webSocketChannelInterceptor()});
    }

    public void configureClientOutboundChannel(ChannelRegistration registration) {
        registration.taskExecutor().corePoolSize(10).maxPoolSize(20).keepAliveSeconds(60);
    }

    public boolean configureMessageConverters(List<MessageConverter> messageConverters) {
        return super.configureMessageConverters(messageConverters);
    }
}

