/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.websocket.interceptor;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.websocket.domain.WebSocketPrincipal;
import com.taotao.cloud.websocket.properties.WebSocketProperties;
import javax.servlet.http.HttpSession;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.MessageHeaderAccessor;

public class WebSocketChannelInterceptor
implements ChannelInterceptor {
    private WebSocketProperties webSocketProperties;

    public void setWebSocketProperties(WebSocketProperties webSocketProperties) {
        this.webSocketProperties = webSocketProperties;
    }

    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        StompHeaderAccessor accessor = (StompHeaderAccessor)MessageHeaderAccessor.getAccessor(message, StompHeaderAccessor.class);
        if (StompCommand.CONNECT.equals((Object)accessor.getCommand())) {
            String token = (String)accessor.getNativeHeader(this.webSocketProperties.getPrincipalAttribute()).get(0);
            WebSocketPrincipal principal = (WebSocketPrincipal)accessor.getUser();
            LogUtils.debug((String)"Authentication user [{}], Token from frontend is [{}].", (Object[])new Object[]{principal, token});
        }
        return message;
    }

    public void postSend(Message<?> message, MessageChannel channel, boolean sent) {
        StompHeaderAccessor accessor = StompHeaderAccessor.wrap(message);
        HttpSession httpSession = (HttpSession)accessor.getSessionAttributes().get("HTTP_SESSION");
    }

    public void afterSendCompletion(Message<?> message, MessageChannel channel, boolean sent, Exception ex) {
    }

    public boolean preReceive(MessageChannel channel) {
        return false;
    }

    public Message<?> postReceive(Message<?> message, MessageChannel channel) {
        return message;
    }

    public void afterReceiveCompletion(Message<?> message, MessageChannel channel, Exception ex) {
    }
}

