/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.websocket.interceptor;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.websocket.domain.WebSocketPrincipal;
import com.taotao.cloud.websocket.properties.WebSocketProperties;
import java.security.Principal;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.server.support.DefaultHandshakeHandler;

public class WebSocketHandshakeHandler
extends DefaultHandshakeHandler {
    private WebSocketProperties webSocketProperties;

    public void setWebSocketProperties(WebSocketProperties webSocketProperties) {
        this.webSocketProperties = webSocketProperties;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Principal determineUser(ServerHttpRequest request, WebSocketHandler wsHandler, Map<String, Object> attributes) {
        Principal principal = request.getPrincipal();
        if (ObjectUtils.isNotEmpty((Object)principal)) {
            LogUtils.info((String)"Get user principal from request, value is  [{}].", (Object[])new Object[]{principal.getName()});
            return principal;
        }
        Object user = null;
        HttpServletRequest httpServletRequest = this.getHttpServletRequest(request);
        if (ObjectUtils.isNotEmpty((Object)httpServletRequest)) {
            user = httpServletRequest.getAttribute(this.webSocketProperties.getPrincipalAttribute());
            if (ObjectUtils.isEmpty((Object)user)) {
                user = httpServletRequest.getParameter(this.webSocketProperties.getPrincipalAttribute());
                if (ObjectUtils.isEmpty((Object)user)) {
                    user = httpServletRequest.getHeader("X-taotao-Session");
                } else {
                    LogUtils.info((String)"Get user principal [{}] from request parameter, use parameter  [{}]..", (Object[])new Object[]{user, this.webSocketProperties.getPrincipalAttribute()});
                }
            } else {
                LogUtils.info((String)"Get user principal [{}] from request attribute, use attribute  [{}]..", (Object[])new Object[]{user, this.webSocketProperties.getPrincipalAttribute()});
            }
        }
        if (!ObjectUtils.isEmpty(user)) {
            LogUtils.info((String)"Get user principal [{}] from request header X_TAOTAO_SESSION.", (Object[])new Object[]{user});
            return new WebSocketPrincipal((String)user);
        }
        HttpSession httpSession = this.getSession(request);
        if (!ObjectUtils.isNotEmpty((Object)httpSession)) {
            LogUtils.error((String)"Cannot find session from websocket request.", (Object[])new Object[0]);
            return null;
        }
        user = httpSession.getAttribute(this.webSocketProperties.getPrincipalAttribute());
        if (ObjectUtils.isEmpty((Object)user)) {
            user = httpSession.getId();
            return new WebSocketPrincipal((String)user);
        }
        LogUtils.info((String)"Get user principal [{}] from httpsession, use attribute  [{}].", (Object[])new Object[]{user, this.webSocketProperties.getPrincipalAttribute()});
        return new WebSocketPrincipal((String)user);
    }

    private HttpServletRequest getHttpServletRequest(ServerHttpRequest request) {
        if (request instanceof ServletServerHttpRequest) {
            ServletServerHttpRequest serverRequest = (ServletServerHttpRequest)request;
            return serverRequest.getServletRequest();
        }
        return null;
    }

    private HttpSession getSession(ServerHttpRequest request) {
        HttpServletRequest httpServletRequest = this.getHttpServletRequest(request);
        if (ObjectUtils.isNotEmpty((Object)httpServletRequest)) {
            return httpServletRequest.getSession(false);
        }
        return null;
    }
}

