/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.websocket.processor;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.websocket.domain.WebSocketMessage;
import com.taotao.cloud.websocket.exception.IllegalChannelException;
import com.taotao.cloud.websocket.exception.PrincipalNotFoundException;
import com.taotao.cloud.websocket.processor.WebSocketMessageSender;
import com.taotao.cloud.websocket.properties.WebSocketProperties;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.codec.JsonJacksonCodec;
import org.springframework.beans.factory.InitializingBean;

public class WebSocketClusterProcessor
implements InitializingBean {
    private RedissonClient redissonClient;
    private WebSocketProperties webSocketProperties;
    private WebSocketMessageSender webSocketMessageSender;

    public void setRedissonClient(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }

    public void setWebSocketProperties(WebSocketProperties webSocketProperties) {
        this.webSocketProperties = webSocketProperties;
    }

    public void setWebSocketMessageSender(WebSocketMessageSender webSocketMessageSender) {
        this.webSocketMessageSender = webSocketMessageSender;
    }

    public void toClusterUser(WebSocketMessage<String> webSocketMessage) {
        try {
            this.webSocketMessageSender.toUser(webSocketMessage);
        }
        catch (PrincipalNotFoundException e) {
            RTopic rTopic = this.redissonClient.getTopic(this.webSocketProperties.getTopic(), (Codec)new JsonJacksonCodec());
            rTopic.publish(webSocketMessage);
            LogUtils.debug((String)"Current instance can not found user [{}], publish message.", (Object[])new Object[]{webSocketMessage.getTo()});
        }
        catch (IllegalChannelException e) {
            LogUtils.error((String)"Web socket channel is incorrect.", (Object[])new Object[0]);
        }
    }

    public void afterPropertiesSet() throws Exception {
        RTopic topic = this.redissonClient.getTopic(this.webSocketProperties.getTopic());
        topic.addListener(WebSocketMessage.class, (charSequence, webSocketMessage) -> {
            LogUtils.debug((String)"Redisson received web socket sync message [{}]", (Object[])new Object[]{webSocketMessage});
            this.webSocketMessageSender.toUser(webSocketMessage);
        });
    }
}

