/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.websocket.processor;

import com.taotao.cloud.common.utils.log.LogUtils;
import com.taotao.cloud.websocket.domain.WebSocketChannel;
import com.taotao.cloud.websocket.domain.WebSocketMessage;
import com.taotao.cloud.websocket.exception.IllegalChannelException;
import com.taotao.cloud.websocket.exception.PrincipalNotFoundException;
import com.taotao.cloud.websocket.properties.WebSocketProperties;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.messaging.simp.user.SimpUser;
import org.springframework.messaging.simp.user.SimpUserRegistry;

public class WebSocketMessageSender {
    private SimpMessagingTemplate simpMessagingTemplate;
    private SimpUserRegistry simpUserRegistry;
    private WebSocketProperties webSocketProperties;

    public void setSimpMessagingTemplate(SimpMessagingTemplate simpMessagingTemplate) {
        this.simpMessagingTemplate = simpMessagingTemplate;
    }

    public void setSimpUserRegistry(SimpUserRegistry simpUserRegistry) {
        this.simpUserRegistry = simpUserRegistry;
    }

    public void setWebSocketProperties(WebSocketProperties webSocketProperties) {
        this.webSocketProperties = webSocketProperties;
    }

    public <T> void toUser(WebSocketMessage<T> webSocketMessage) throws IllegalChannelException, PrincipalNotFoundException {
        WebSocketChannel webSocketChannel = WebSocketChannel.getWebSocketChannel(webSocketMessage.getChannel());
        if (ObjectUtils.isEmpty((Object)((Object)webSocketChannel))) {
            throw new IllegalChannelException("Web socket channel is incorrect!");
        }
        SimpUser simpUser = this.simpUserRegistry.getUser(webSocketMessage.getTo());
        if (ObjectUtils.isEmpty((Object)simpUser)) {
            throw new PrincipalNotFoundException("Web socket user principal is not found!");
        }
        LogUtils.debug((String)"Web socket send message to user [{}].", (Object[])new Object[]{webSocketMessage.getTo()});
        this.simpMessagingTemplate.convertAndSendToUser(webSocketMessage.getTo(), webSocketChannel.getDestination(), webSocketMessage.getPayload());
    }

    public <T> void toAll(T payload) {
        this.simpMessagingTemplate.convertAndSend((Object)this.webSocketProperties.getBroadcast(), payload);
    }
}

