/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.cloud.websocket.properties;

import com.taotao.cloud.common.constant.SymbolConstants;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;

@RefreshScope
@ConfigurationProperties(prefix="taotao.cloud.websocket")
public class WebSocketProperties {
    public static final String PREFIX = "taotao.cloud.websocket";
    private boolean enabled = false;
    private String endpoint = "stomp/websocketjs";
    private String broadcast = "topic";
    private String peerToPeer = "private";
    private List<String> applicationDestinationPrefixes;
    private String userDestinationPrefix;
    private String topic = "ws";
    private String principalAttribute = "openid";

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private String format(String endpoint) {
        if (StringUtils.isNotBlank((CharSequence)endpoint) && !StringUtils.startsWith((CharSequence)endpoint, (CharSequence)SymbolConstants.FORWARD_SLASH)) {
            return SymbolConstants.FORWARD_SLASH + endpoint;
        }
        return endpoint;
    }

    public String getEndpoint() {
        return this.format(this.endpoint);
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getBroadcast() {
        return this.format(this.broadcast);
    }

    public void setBroadcast(String broadcast) {
        this.broadcast = broadcast;
    }

    public String getPeerToPeer() {
        return this.format(this.peerToPeer);
    }

    public void setPeerToPeer(String peerToPeer) {
        this.peerToPeer = peerToPeer;
    }

    public List<String> getApplicationDestinationPrefixes() {
        return this.applicationDestinationPrefixes;
    }

    public void setApplicationDestinationPrefixes(List<String> applicationDestinationPrefixes) {
        this.applicationDestinationPrefixes = applicationDestinationPrefixes;
    }

    public String[] getApplicationPrefixes() {
        List<String> prefixes = this.getApplicationDestinationPrefixes();
        if (CollectionUtils.isNotEmpty(prefixes)) {
            List<String> wellFormed = prefixes.stream().map(this::format).toList();
            String[] result = new String[wellFormed.size()];
            return wellFormed.toArray(result);
        }
        return new String[0];
    }

    public String getUserDestinationPrefix() {
        return this.format(this.userDestinationPrefix);
    }

    public void setUserDestinationPrefix(String userDestinationPrefix) {
        this.userDestinationPrefix = userDestinationPrefix;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getPrincipalAttribute() {
        return this.principalAttribute;
    }

    public void setPrincipalAttribute(String principalAttribute) {
        this.principalAttribute = principalAttribute;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

