/*
 * Decompiled with CFR 0.152.
 */
package skydrinker.testcontainers.mailcatcher;

import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;
import org.testcontainers.containers.wait.strategy.Wait;
import skydrinker.testcontainers.mailcatcher.MailcatcherMail;

public abstract class ExtendableMailCatcherContainer<SELF extends ExtendableMailCatcherContainer<SELF>>
extends GenericContainer<SELF> {
    private static final String MAILCATCHER_IMAGE = "dockage/mailcatcher";
    private static final String MAILCATCHER_VERSION = "0.9.0";
    private static final int MAILCATCHER_SMTP_PORT = 1025;
    private static final int MAILCATCHER_HTTP_PORT = 1080;
    private static final Duration DEFAULT_STARTUP_TIMEOUT = Duration.ofSeconds(30L);
    private static final String MESSAGES_API_PATH = "/messages";
    private Duration startupTimeout = DEFAULT_STARTUP_TIMEOUT;

    public ExtendableMailCatcherContainer() {
        this("dockage/mailcatcher:0.9.0");
    }

    public ExtendableMailCatcherContainer(String dockerImageName) {
        super(dockerImageName);
        this.withExposedPorts(new Integer[]{1025, 1080});
        this.withLogConsumer((Consumer)new Slf4jLogConsumer(this.logger()));
    }

    protected void configure() {
        HostPortWaitStrategy waitStrategy = Wait.forListeningPorts((int[])new int[]{1080, 1025});
        this.setWaitStrategy(waitStrategy.withStartupTimeout(this.startupTimeout));
    }

    public SELF withCommand(String cmd) {
        throw new IllegalStateException("You are trying to set custom container commands, which is not supported by this Testcontainer.");
    }

    public SELF withCommand(String ... commandParts) {
        throw new IllegalStateException("You are trying to set custom container commands, which is not supported by this Testcontainer.");
    }

    public SELF withStartupTimeout(Duration startupTimeout) {
        this.startupTimeout = startupTimeout;
        return (SELF)((Object)((ExtendableMailCatcherContainer)this.self()));
    }

    public int getHttpPort() {
        return this.getMappedPort(1080);
    }

    public int getSmtpPort() {
        return this.getMappedPort(1025);
    }

    public Duration getStartupTimeout() {
        return this.startupTimeout;
    }

    public String getMessagesApiUrl() {
        return String.format("http://%s:%s%s", this.getHost(), this.getHttpPort(), MESSAGES_API_PATH);
    }

    public List<MailcatcherMail> getAllEmails() {
        List<MailcatcherMail> emailsSummaries = this.getAllEmailsSummary();
        ArrayList<MailcatcherMail> emailsWithBodies = new ArrayList<MailcatcherMail>();
        for (MailcatcherMail mail : emailsSummaries) {
            emailsWithBodies.add(this.getEmailById(mail.id));
        }
        return emailsWithBodies;
    }

    protected List<MailcatcherMail> getAllEmailsSummary() {
        ValidatableResponse messagesResponse = (ValidatableResponse)((Response)RestAssured.given().when().get(this.getMessagesApiUrl(), new Object[0])).then();
        return Arrays.asList((MailcatcherMail[])messagesResponse.extract().body().as(MailcatcherMail[].class));
    }

    public MailcatcherMail getEmailById(int emailId) {
        String jsonEmailEndpointUrl = String.format("%s/%s.json", this.getMessagesApiUrl(), emailId);
        try {
            MailcatcherMail mail = (MailcatcherMail)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get(jsonEmailEndpointUrl, new Object[0])).then()).statusCode(200)).extract().body().as(MailcatcherMail.class);
            for (String emailFormat : mail.formats) {
                String singleMailEndpointUrl = String.format("%s/%s.%s", this.getMessagesApiUrl(), emailId, emailFormat);
                String body = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get(singleMailEndpointUrl, new Object[0])).then()).statusCode(200)).extract().body().asString();
                mail.bodies.put(emailFormat, body);
            }
            return mail;
        }
        catch (AssertionError e) {
            return null;
        }
    }

    public MailcatcherMail getLastEmail() {
        List<MailcatcherMail> emailsSummaries = this.getAllEmailsSummary();
        if (emailsSummaries.isEmpty()) {
            return null;
        }
        return this.getEmailById(emailsSummaries.get((int)(emailsSummaries.size() - 1)).id);
    }

    public String getMailCatcherDefaultVersion() {
        return MAILCATCHER_VERSION.equals(MAILCATCHER_VERSION) ? "0.9.0-SNAPSHOT" : MAILCATCHER_VERSION;
    }
}

