/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.dex.utils;

import jadx.plugins.input.dex.DexException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.Adler32;

public class DexCheckSum {
    public static void verify(byte[] content, String fileName) {
        int len = content.length;
        if (len < 12) {
            throw new DexException("Dex file truncated, length: " + len + ", file: " + fileName);
        }
        int checksum = ByteBuffer.wrap(content, 8, 4).order(ByteOrder.LITTLE_ENDIAN).getInt();
        Adler32 adler32 = new Adler32();
        adler32.update(content, 12, len - 12);
        int fileChecksum = (int)adler32.getValue();
        if (checksum != fileChecksum) {
            throw new DexException(String.format("Bad dex file checksum: 0x%08x, expected: 0x%08x, file: %s", fileChecksum, checksum, fileName));
        }
    }
}

