/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.logs;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import jadx.gui.logs.ILogListener;
import jadx.gui.logs.LimitedQueue;
import jadx.gui.logs.LogEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;

public class LogCollector
extends AppenderBase<ILoggingEvent> {
    public static final int BUFFER_SIZE = 5000;
    private static final LogCollector INSTANCE = new LogCollector();
    private final List<ILogListener> listeners = new ArrayList<ILogListener>();
    private final Queue<LogEvent> buffer = new LimitedQueue<LogEvent>(5000);
    private Layout<ILoggingEvent> layout;

    public static LogCollector getInstance() {
        return INSTANCE;
    }

    public static void register() {
        Logger rootLogger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        LoggerContext loggerContext = rootLogger.getLoggerContext();
        PatternLayout layout = new PatternLayout();
        layout.setContext((Context)loggerContext);
        layout.setPattern("%-5level: %msg%n");
        layout.start();
        INSTANCE.setContext((Context)loggerContext);
        INSTANCE.setLayout((Layout<ILoggingEvent>)layout);
        INSTANCE.start();
        rootLogger.addAppender((Appender)INSTANCE);
    }

    public LogCollector() {
        this.setName("LogCollector");
    }

    protected synchronized void append(ILoggingEvent event) {
        String msg = this.layout.doLayout((Object)event);
        LogEvent logEvent = new LogEvent(event.getLevel(), event.getLoggerName(), msg);
        this.buffer.offer(logEvent);
        this.listeners.forEach(l -> l.onAppend(logEvent));
    }

    private void setLayout(Layout<ILoggingEvent> layout) {
        this.layout = layout;
    }

    public synchronized void registerListener(ILogListener listener) {
        this.listeners.add(listener);
        this.buffer.forEach(listener::onAppend);
    }

    public synchronized boolean removeListener(@Nullable ILogListener listener) {
        if (listener == null) {
            return false;
        }
        return this.listeners.removeIf(l -> l == listener);
    }

    public synchronized boolean removeListenerByClass(Class<?> listenerCls) {
        return this.listeners.removeIf(l -> l.getClass().equals(listenerCls));
    }

    public synchronized void reset() {
        this.buffer.clear();
        this.listeners.forEach(ILogListener::onReload);
    }
}

