/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.logs;

import ch.qos.logback.classic.Level;
import jadx.gui.logs.LogAppender;
import jadx.gui.logs.LogCollector;
import jadx.gui.logs.LogMode;
import jadx.gui.logs.LogOptions;
import jadx.gui.settings.JadxSettings;
import jadx.gui.treemodel.JInputScript;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.codearea.AbstractCodeArea;
import jadx.gui.ui.tab.TabBlueprint;
import jadx.gui.utils.NLS;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeListener;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.jetbrains.annotations.Nullable;

public class LogPanel
extends JPanel {
    private static final long serialVersionUID = -8077649118322056081L;
    private static final Level[] LEVEL_ITEMS = new Level[]{Level.DEBUG, Level.INFO, Level.WARN, Level.ERROR};
    private final MainWindow mainWindow;
    private final Runnable dockAction;
    private final Runnable hideAction;
    private RSyntaxTextArea textPane;
    private JComboBox<LogMode> modeCb;
    private JComboBox<Level> levelCb;
    private ChangeListener activeTabListener;

    public LogPanel(MainWindow mainWindow, LogOptions logOptions, Runnable dockAction, Runnable hideAction) {
        this.mainWindow = mainWindow;
        this.dockAction = dockAction;
        this.hideAction = hideAction;
        this.initUI(logOptions);
        this.applyLogOptions(logOptions);
    }

    public void applyLogOptions(LogOptions logOptions) {
        if (logOptions.getMode() == LogMode.CURRENT_SCRIPT) {
            String scriptName = this.getCurrentScriptName();
            if (scriptName != null) {
                logOptions = LogOptions.forScript(scriptName);
            }
            this.registerActiveTabListener();
        } else {
            this.removeActiveTabListener();
        }
        if (this.modeCb.getSelectedItem() != logOptions.getMode()) {
            this.modeCb.setSelectedItem((Object)logOptions.getMode());
        }
        if (this.levelCb.getSelectedItem() != logOptions.getLogLevel()) {
            this.levelCb.setSelectedItem(logOptions.getLogLevel());
        }
        this.registerLogListener(logOptions);
    }

    public void loadSettings() {
        AbstractCodeArea.loadCommonSettings(this.mainWindow, this.textPane);
    }

    private void initUI(LogOptions logOptions) {
        JadxSettings settings = this.mainWindow.getSettings();
        this.textPane = AbstractCodeArea.getDefaultArea(this.mainWindow);
        this.textPane.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        this.modeCb = new JComboBox<LogMode>(LogMode.values());
        this.modeCb.setSelectedItem((Object)logOptions.getMode());
        this.modeCb.addActionListener(e -> this.applyLogOptions(LogOptions.forMode((LogMode)((Object)((Object)this.modeCb.getSelectedItem())))));
        JLabel modeLabel = new JLabel(NLS.str("log_viewer.mode"));
        modeLabel.setLabelFor(this.modeCb);
        this.levelCb = new JComboBox<Level>(LEVEL_ITEMS);
        this.levelCb.setSelectedItem(logOptions.getLogLevel());
        this.levelCb.addActionListener(e -> this.applyLogOptions(LogOptions.forLevel((Level)this.levelCb.getSelectedItem())));
        JLabel levelLabel = new JLabel(NLS.str("log_viewer.log_level"));
        levelLabel.setLabelFor(this.levelCb);
        JButton clearBtn = new JButton(NLS.str("log_viewer.clear"));
        clearBtn.addActionListener(ev -> {
            LogCollector.getInstance().reset();
            this.textPane.setText("");
        });
        JButton dockBtn = new JButton(NLS.str(settings.isDockLogViewer() ? "log_viewer.undock" : "log_viewer.dock"));
        dockBtn.addActionListener(ev -> this.dockAction.run());
        JButton hideBtn = new JButton(NLS.str("log_viewer.hide"));
        hideBtn.addActionListener(ev -> this.hideAction.run());
        JPanel start = new JPanel();
        start.setLayout(new BoxLayout(start, 2));
        start.add(modeLabel);
        start.add(Box.createRigidArea(new Dimension(5, 0)));
        start.add(this.modeCb);
        start.add(Box.createRigidArea(new Dimension(15, 0)));
        start.add(levelLabel);
        start.add(Box.createRigidArea(new Dimension(5, 0)));
        start.add(this.levelCb);
        start.add(Box.createRigidArea(new Dimension(5, 0)));
        JPanel end = new JPanel();
        end.setLayout(new BoxLayout(end, 2));
        end.add(clearBtn);
        end.add(Box.createRigidArea(new Dimension(15, 0)));
        end.add(dockBtn);
        end.add(Box.createRigidArea(new Dimension(15, 0)));
        end.add(hideBtn);
        JPanel controlPane = new JPanel();
        controlPane.setLayout(new BorderLayout());
        controlPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        controlPane.add((Component)start, "Before");
        controlPane.add((Component)end, "After");
        JScrollPane scrollPane = new JScrollPane((Component)this.textPane);
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)controlPane, "First");
        this.add((Component)scrollPane, "Center");
    }

    private void registerLogListener(LogOptions logOptions) {
        LogCollector logCollector = LogCollector.getInstance();
        logCollector.removeListenerByClass(LogAppender.class);
        this.textPane.setText("");
        logCollector.registerListener(new LogAppender(logOptions, this.textPane));
    }

    @Nullable
    private String getCurrentScriptName() {
        JNode node;
        TabBlueprint selectedTab = this.mainWindow.getTabsController().getSelectedTab();
        if (selectedTab != null && (node = selectedTab.getNode()) instanceof JInputScript) {
            return node.getName();
        }
        return null;
    }

    private synchronized void registerActiveTabListener() {
        this.removeActiveTabListener();
        this.activeTabListener = e -> {
            String scriptName = this.getCurrentScriptName();
            if (scriptName != null) {
                this.applyLogOptions(LogOptions.forScript(scriptName));
            }
        };
        this.mainWindow.getTabbedPane().addChangeListener(this.activeTabListener);
    }

    private synchronized void removeActiveTabListener() {
        if (this.activeTabListener != null) {
            this.mainWindow.getTabbedPane().removeChangeListener(this.activeTabListener);
            this.activeTabListener = null;
        }
    }

    public void dispose() {
        LogCollector.getInstance().removeListenerByClass(LogAppender.class);
        this.removeActiveTabListener();
    }
}

