/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.plugins.script;

import jadx.core.utils.ListUtils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.gui.plugins.script.ScriptCompletionData;
import jadx.gui.ui.codearea.AbstractCodeArea;
import jadx.gui.utils.Icons;
import jadx.plugins.script.ide.ScriptCompletionResult;
import jadx.plugins.script.ide.ScriptServices;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import kotlin.script.experimental.api.ScriptDiagnostic;
import kotlin.script.experimental.api.SourceCode;
import kotlin.script.experimental.api.SourceCodeCompletionVariant;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.CompletionProviderBase;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptCompleteProvider
extends CompletionProviderBase {
    private static final Logger LOG = LoggerFactory.getLogger(ScriptCompleteProvider.class);
    private static final Map<String, Icon> ICONS_MAP = ScriptCompleteProvider.buildIconsMap();
    private final AbstractCodeArea codeArea;
    private ScriptServices scriptServices;

    private static Map<String, Icon> buildIconsMap() {
        HashMap<String, Icon> map = new HashMap<String, Icon>();
        map.put("class", Icons.CLASS);
        map.put("method", Icons.METHOD);
        map.put("field", Icons.FIELD);
        map.put("property", Icons.PROPERTY);
        map.put("parameter", Icons.PARAMETER);
        map.put("package", Icons.PACKAGE);
        return map;
    }

    public ScriptCompleteProvider(AbstractCodeArea codeArea) {
        this.codeArea = codeArea;
    }

    private List<Completion> getCompletions() {
        try {
            String code = this.codeArea.getText();
            int caretPos = this.codeArea.getCaretPosition();
            this.scriptServices = new ScriptServices();
            String scriptName = this.codeArea.getNode().getName();
            ScriptCompletionResult result = this.scriptServices.complete(scriptName, code, caretPos);
            int replacePos = this.getReplacePos(caretPos, result);
            if (!result.getReports().isEmpty()) {
                LOG.debug("Script completion reports: {}", (Object)result.getReports());
            }
            return this.convertCompletions(result.getCompletions(), code, replacePos);
        }
        catch (Exception e) {
            LOG.error("Code completion failed", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private List<Completion> convertCompletions(List<SourceCodeCompletionVariant> completions, String code, int replacePos) {
        if (completions.isEmpty()) {
            return Collections.emptyList();
        }
        if (LOG.isDebugEnabled()) {
            String cmplStr = completions.stream().map(SourceCodeCompletionVariant::toString).collect(Collectors.joining("\n"));
            LOG.debug("Completions:\n{}", (Object)cmplStr);
        }
        int count = completions.size();
        ArrayList<Completion> list = new ArrayList<Completion>(count);
        for (int i = 0; i < count; ++i) {
            SourceCodeCompletionVariant c = completions.get(i);
            if (Objects.equals(c.getIcon(), "keyword")) continue;
            ScriptCompletionData cmpl = new ScriptCompletionData((CompletionProvider)this, count - i);
            cmpl.setData(c.getText(), code, replacePos);
            if (Objects.equals(c.getIcon(), "method") && !Objects.equals(c.getText(), c.getDisplayText())) {
                cmpl.setSummary(c.getDisplayText() + " " + c.getTail());
            } else {
                cmpl.setSummary(c.getTail());
            }
            cmpl.setToolTip(c.getDisplayText());
            Icon icon = ICONS_MAP.get(c.getIcon());
            cmpl.setIcon(icon != null ? icon : Icons.FILE);
            list.add(cmpl);
        }
        return list;
    }

    private int getReplacePos(int caretPos, ScriptCompletionResult result) throws BadLocationException {
        int lineRaw = this.codeArea.getLineOfOffset(caretPos);
        int lineStart = this.codeArea.getLineStartOffset(lineRaw);
        int line = lineRaw + 1;
        int col = caretPos - lineStart + 1;
        List reports = result.getReports();
        ScriptDiagnostic cmplReport = (ScriptDiagnostic)ListUtils.filterOnlyOne((List)reports, r -> {
            if (r.getSeverity() == ScriptDiagnostic.Severity.ERROR && r.getLocation() != null) {
                SourceCode.Position start = r.getLocation().getStart();
                return start.getLine() == line && r.getMessage().endsWith("ABCDEF");
            }
            return false;
        });
        if (cmplReport == null) {
            LOG.warn("Failed to find completion report in: {}", (Object)reports);
            return caretPos;
        }
        reports.remove(cmplReport);
        int reportCol = Objects.requireNonNull(cmplReport.getLocation()).getStart().getCol();
        return caretPos - (col - reportCol);
    }

    public String getAlreadyEnteredText(JTextComponent comp) {
        try {
            int pos = this.codeArea.getCaretPosition();
            return this.codeArea.getText(0, pos);
        }
        catch (Exception e) {
            throw new JadxRuntimeException("Failed to get text before caret", (Throwable)e);
        }
    }

    public List<Completion> getCompletionsAt(JTextComponent comp, Point p) {
        return this.getCompletions();
    }

    protected List<Completion> getCompletionsImpl(JTextComponent comp) {
        return this.getCompletions();
    }

    public List<ParameterizedCompletion> getParameterizedCompletions(JTextComponent tc) {
        return null;
    }
}

