/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.search.providers;

import jadx.api.ResourceFile;
import jadx.api.ResourceType;
import jadx.api.plugins.utils.CommonFileUtils;
import jadx.api.utils.CodeUtils;
import jadx.gui.jobs.Cancelable;
import jadx.gui.search.ISearchProvider;
import jadx.gui.search.SearchSettings;
import jadx.gui.treemodel.JNode;
import jadx.gui.treemodel.JResSearchNode;
import jadx.gui.treemodel.JResource;
import jadx.gui.treemodel.JRoot;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.dialog.SearchDialog;
import jadx.gui.utils.NLS;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceSearchProvider
implements ISearchProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceSearchProvider.class);
    private final SearchSettings searchSettings;
    private final Set<String> extSet;
    private final SearchDialog searchDialog;
    private final int sizeLimit;
    private boolean anyExt;
    private final Deque<JResource> resQueue;
    private int pos;
    private int loadErrors = 0;
    private int skipBySize = 0;

    public ResourceSearchProvider(MainWindow mw, SearchSettings searchSettings, SearchDialog searchDialog) {
        this.searchSettings = searchSettings;
        this.extSet = this.buildAllowedFilesExtensions(searchSettings.getResFilterStr());
        this.sizeLimit = searchSettings.getResSizeLimit() * 1024 * 1024;
        this.searchDialog = searchDialog;
        JResource activeResource = searchSettings.getActiveResource();
        this.resQueue = activeResource != null ? new ArrayDeque<JResource>(Collections.singleton(activeResource)) : ResourceSearchProvider.initResQueue(mw);
    }

    @Override
    @Nullable
    public JNode next(Cancelable cancelable) {
        do {
            if (cancelable.isCanceled()) {
                return null;
            }
            JResource resNode = this.getNextResFile(cancelable);
            if (resNode == null) {
                return null;
            }
            JNode newResult = this.search(resNode);
            if (newResult != null) {
                return newResult;
            }
            this.pos = 0;
            this.resQueue.removeLast();
            this.addChildren(resNode);
        } while (!this.resQueue.isEmpty());
        return null;
    }

    private JNode search(JResource resNode) {
        String content;
        try {
            content = resNode.getCodeInfo().getCodeStr();
        }
        catch (Exception e) {
            LOG.error("Failed to load resource node content", (Throwable)e);
            return null;
        }
        String searchString = this.searchSettings.getSearchString();
        int newPos = this.searchSettings.getSearchMethod().find(content, searchString, this.pos);
        if (newPos == -1) {
            return null;
        }
        int lineStart = 1 + CodeUtils.getNewLinePosBefore((String)content, (int)newPos);
        int lineEnd = CodeUtils.getNewLinePosAfter((String)content, (int)newPos);
        int end = lineEnd == -1 ? content.length() : lineEnd;
        String line = content.substring(lineStart, end);
        this.pos = end;
        return new JResSearchNode(resNode, line.trim(), newPos);
    }

    @Nullable
    private JResource getNextResFile(Cancelable cancelable) {
        JResource node;
        while ((node = this.resQueue.peekLast()) != null && !cancelable.isCanceled()) {
            if (node.getType() == JResource.JResType.FILE) {
                if (this.shouldProcess(node) && this.loadResNode(node)) {
                    return node;
                }
                this.resQueue.removeLast();
                continue;
            }
            this.resQueue.removeLast();
            this.loadResNode(node);
            this.addChildren(node);
        }
        return null;
    }

    private void updateProgressInfo() {
        StringBuilder sb = new StringBuilder();
        if (this.loadErrors != 0) {
            sb.append("  ").append(NLS.str("search_dialog.resources_load_errors", this.loadErrors));
        }
        if (this.skipBySize != 0) {
            sb.append("  ").append(NLS.str("search_dialog.resources_skip_by_size", this.skipBySize));
        }
        if (sb.length() != 0) {
            sb.append("  ").append(NLS.str("search_dialog.resources_check_logs"));
        }
        this.searchDialog.updateProgressLabel(sb.toString());
    }

    private boolean loadResNode(JResource node) {
        try {
            node.loadNode();
            return true;
        }
        catch (Exception e) {
            LOG.error("Error load resource node: {}", (Object)node, (Object)e);
            ++this.loadErrors;
            this.updateProgressInfo();
            return false;
        }
    }

    private void addChildren(JResource resNode) {
        this.resQueue.addAll(resNode.getSubNodes());
    }

    private static Deque<JResource> initResQueue(MainWindow mw) {
        JRoot jRoot = mw.getTreeRoot();
        ArrayDeque<JResource> deque = new ArrayDeque<JResource>(jRoot.getChildCount());
        Enumeration<TreeNode> children = jRoot.children();
        while (children.hasMoreElements()) {
            TreeNode node = children.nextElement();
            if (!(node instanceof JResource)) continue;
            JResource resNode = (JResource)node;
            deque.add(resNode);
        }
        return deque;
    }

    private Set<String> buildAllowedFilesExtensions(String srhResourceFileExt) {
        String str = srhResourceFileExt.trim();
        if (str.isEmpty() || str.equals("*")) {
            this.anyExt = true;
            return Collections.emptySet();
        }
        HashSet<String> set = new HashSet<String>();
        for (String extStr : str.split("[|.]")) {
            String ext = extStr.trim();
            if (ext.isEmpty()) continue;
            this.anyExt = ext.equals("*");
            if (this.anyExt) break;
            set.add(ext);
        }
        return set;
    }

    private boolean shouldProcess(JResource resNode) {
        ResourceFile resFile = resNode.getResFile();
        if (resFile.getType() == ResourceType.ARSC) {
            return this.anyExt || this.extSet.contains("xml");
        }
        if (!this.anyExt) {
            String fileExt = CommonFileUtils.getFileExtension((String)resFile.getOriginalName());
            if (fileExt == null) {
                return false;
            }
            if (!this.extSet.contains(fileExt)) {
                return false;
            }
        }
        if (this.sizeLimit <= 0) {
            return true;
        }
        try {
            int charsCount = resNode.getCodeInfo().getCodeStr().length();
            long size = (long)charsCount * 8L;
            if (size > (long)this.sizeLimit) {
                LOG.info("Resource search skipped because of size limit. Resource '{}' size {} bytes, limit: {}", new Object[]{resNode.getName(), size, this.sizeLimit});
                ++this.skipBySize;
                this.updateProgressInfo();
                return false;
            }
            return true;
        }
        catch (Exception e) {
            LOG.warn("Resource load error: {}", (Object)resNode, (Object)e);
            ++this.loadErrors;
            this.updateProgressInfo();
            return false;
        }
    }

    @Override
    public int progress() {
        return 0;
    }

    @Override
    public int total() {
        return 0;
    }
}

