/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.settings.ui.cache;

import jadx.api.plugins.events.IJadxEvent;
import jadx.api.plugins.events.types.ReloadProject;
import jadx.core.utils.ListUtils;
import jadx.core.utils.Utils;
import jadx.gui.cache.manager.CacheEntry;
import jadx.gui.cache.manager.CacheManager;
import jadx.gui.settings.JadxProject;
import jadx.gui.settings.ui.cache.CachesTableModel;
import jadx.gui.settings.ui.cache.CachesTableRenderer;
import jadx.gui.settings.ui.cache.TableRow;
import jadx.gui.ui.MainWindow;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import jadx.gui.utils.ui.MousePressedHandler;
import java.awt.Dimension;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JTable;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachesTable
extends JTable {
    private static final long serialVersionUID = 5984107298264276049L;
    private static final Logger LOG = LoggerFactory.getLogger(CachesTable.class);
    private final MainWindow mainWindow;
    private final CachesTableModel dataModel;

    public CachesTable(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        this.dataModel = new CachesTableModel();
        this.setModel(this.dataModel);
        this.setDefaultRenderer(Object.class, new CachesTableRenderer());
        this.setSelectionMode(0);
        this.setAutoResizeMode(4);
        this.setShowHorizontalLines(true);
        this.setDragEnabled(false);
        this.setColumnSelectionAllowed(false);
        this.setAutoscrolls(true);
        this.setFocusable(false);
        this.addMouseListener(new MousePressedHandler(ev -> {
            int row = this.rowAtPoint(ev.getPoint());
            if (row != -1) {
                this.dataModel.changeSelection(row);
                UiUtils.uiRun(this::updateUI);
            }
        }));
    }

    public void updateData() {
        List<TableRow> rows = this.mainWindow.getCacheManager().getCachesList().stream().map(TableRow::new).collect(Collectors.toList());
        this.updateRows(rows);
    }

    public void reloadData() {
        Map<String, String> prevUsageMap = this.dataModel.getRows().stream().collect(Collectors.toMap(TableRow::getProject, TableRow::getUsage));
        List<TableRow> rows = this.mainWindow.getCacheManager().getCachesList().stream().map(TableRow::new).peek(r -> r.setUsage((String)Utils.getOrElse((Object)((String)prevUsageMap.get(r.getProject())), (Object)"-"))).collect(Collectors.toList());
        this.updateRows(rows);
    }

    private void updateRows(List<TableRow> rows) {
        this.dataModel.setRows(rows);
        int width = this.getPreferredSize().width;
        int height = rows.size() * this.getRowHeight();
        this.setPreferredScrollableViewportSize(new Dimension(width, height));
        UiUtils.uiRun(this::updateUI);
    }

    public void updateSizes() {
        List<Runnable> list = this.dataModel.getRows().stream().map(row -> () -> this.calcSize((TableRow)row)).collect(Collectors.toList());
        this.mainWindow.getBackgroundExecutor().execute(NLS.str("preferences.cache.task.usage"), list, status -> this.updateUI());
    }

    private void calcSize(TableRow row) {
        String cacheDir = row.getCacheEntry().getCache();
        try {
            Path dir = Paths.get(cacheDir, new String[0]);
            if (Files.isDirectory(dir, new LinkOption[0])) {
                long size = CachesTable.calcSizeOfDirectory(dir);
                row.setUsage(FileUtils.byteCountToDisplaySize((long)size));
            } else {
                row.setUsage("not found");
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to calculate size of directory: {}", (Object)cacheDir, (Object)e);
            row.setUsage("error");
        }
    }

    private static long calcSizeOfDirectory(Path dir) {
        long l;
        block8: {
            Stream<Path> stream = Files.walk(dir, new FileVisitOption[0]);
            try {
                long blockSize = Files.getFileStore(dir).getBlockSize();
                l = stream.mapToLong(p -> {
                    if (Files.isRegularFile(p, new LinkOption[0])) {
                        try {
                            long fileSize = Files.size(p);
                            return (fileSize / blockSize + 1L) * blockSize;
                        }
                        catch (Exception e) {
                            LOG.error("Failed to get file size: {}", p, (Object)e);
                        }
                    }
                    return 0L;
                }).sum();
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.error("Failed to calculate directory size: {}", (Object)dir, (Object)e);
                    return 0L;
                }
            }
            stream.close();
        }
        return l;
    }

    public void deleteSelected() {
        this.delete(ListUtils.filter(this.dataModel.getRows(), TableRow::isSelected));
    }

    public void deleteAll() {
        this.delete(this.dataModel.getRows());
    }

    private void delete(List<TableRow> rows) {
        boolean reload = this.searchCurrentProject(rows);
        List<Runnable> list = rows.stream().map(TableRow::getCacheEntry).map(entry -> () -> this.mainWindow.getCacheManager().removeCacheEntry((CacheEntry)entry)).collect(Collectors.toList());
        this.mainWindow.getBackgroundExecutor().execute(NLS.str("preferences.cache.task.delete"), list, status -> {
            this.reloadData();
            if (reload) {
                this.mainWindow.events().send((IJadxEvent)ReloadProject.EVENT);
            }
        });
    }

    private boolean searchCurrentProject(List<TableRow> rows) {
        JadxProject project = this.mainWindow.getProject();
        if (!project.getFilePaths().isEmpty()) {
            String cacheStr = CacheManager.pathToString(project.getCacheDir());
            for (TableRow row : rows) {
                if (!row.getCacheEntry().getCache().equals(cacheStr)) continue;
                project.resetCacheDir();
                LOG.debug("Found current project in cache delete list -> request full reload");
                return true;
            }
        }
        return false;
    }
}

