/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.tree;

import jadx.api.metadata.ICodeNodeRef;
import jadx.core.dex.nodes.RootNode;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JNode;
import jadx.gui.treemodel.JPackage;
import jadx.gui.treemodel.JRoot;
import jadx.gui.ui.MainWindow;
import jadx.gui.utils.JNodeCache;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeExpansionService {
    private static final Logger LOG = LoggerFactory.getLogger(TreeExpansionService.class);
    private static final boolean DEBUG = false;
    private static final Comparator<TreePath> PATH_LENGTH_REVERSE = Comparator.comparingInt(p -> -p.getPathCount());
    private final MainWindow mainWindow;
    private final JTree tree;
    private final JNodeCache nodeCache;

    public TreeExpansionService(MainWindow mainWindow, JTree tree) {
        this.mainWindow = mainWindow;
        this.tree = tree;
        this.nodeCache = mainWindow.getCacheObject().getNodeCache();
    }

    public List<String> save() {
        if (this.tree.getRowCount() == 0 || this.mainWindow.getWrapper().getCurrentDecompiler().isEmpty()) {
            return Collections.emptyList();
        }
        List<TreePath> expandedPaths = TreeExpansionService.collectExpandedPaths(this.tree);
        ArrayList<String> list = new ArrayList<String>();
        for (TreePath expandedPath : expandedPaths) {
            list.add(this.savePath(expandedPath));
        }
        return list;
    }

    public void load(List<String> treeExpansions) {
        ArrayList expandedPaths = new ArrayList();
        this.mainWindow.getBackgroundExecutor().execute(NLS.str("progress.load"), () -> {
            this.loadPaths(treeExpansions, expandedPaths);
            UiUtils.uiRunAndWait(() -> expandedPaths.forEach(path -> {
                try {
                    this.tree.fireTreeWillExpand((TreePath)path);
                }
                catch (Exception e) {
                    throw new JadxRuntimeException("Tree expand error", (Throwable)e);
                }
            }));
        }, s -> expandedPaths.forEach(this.tree::expandPath));
    }

    private void loadPaths(List<String> treeExpansions, List<TreePath> expandedPaths) {
        for (String treeExpansion : treeExpansions) {
            try {
                TreePath treePath = this.loadPath(treeExpansion);
                if (treePath == null) continue;
                expandedPaths.add(treePath);
            }
            catch (Exception e) {
                LOG.warn("Failed to load tree expansion entry: {}", (Object)treeExpansion, (Object)e);
            }
        }
    }

    private String savePath(TreePath path) {
        JNode node = (JNode)path.getLastPathComponent();
        if (node instanceof JPackage) {
            return "p:" + ((JPackage)node).getPkg().getRawFullName();
        }
        if (node instanceof JClass) {
            return "c:" + ((JClass)node).getCls().getRawName();
        }
        return Arrays.stream(path.getPath()).map(p -> ((JNode)p).getID()).skip(1L).collect(Collectors.joining("//", "t:", ""));
    }

    @Nullable
    private TreePath loadPath(String pathStr) {
        String pathData = pathStr.substring(2);
        switch (pathStr.charAt(0)) {
            case 'c': {
                return this.getTreePathForRef((ICodeNodeRef)this.getRoot().resolveRawClass(pathData));
            }
            case 'p': {
                return this.getTreePathForRef((ICodeNodeRef)this.getRoot().resolvePackage(pathData));
            }
            case 't': {
                return this.resolveTreePath(pathData.split("//"));
            }
        }
        throw new JadxRuntimeException("Unknown tree expansion path type: " + pathStr);
    }

    @Nullable
    private TreePath resolveTreePath(String[] pathArr) {
        JNode current = (JNode)this.tree.getModel().getRoot();
        for (String nodeStr : pathArr) {
            JNode node = current.searchNode(n -> n.getID().equals(nodeStr));
            if (node == null) {
                return null;
            }
            current = node;
        }
        return new TreePath(current.getPath());
    }

    @Nullable
    private TreePath getTreePathForRef(@Nullable ICodeNodeRef ref) {
        Object[] pathNodes;
        if (ref == null) {
            return null;
        }
        JNode node = this.nodeCache.makeFrom(ref);
        if (node.getParent() == null) {
            JNode treeNode = ((JRoot)this.tree.getModel().getRoot()).searchNode(node);
            if (treeNode == null) {
                return null;
            }
            node = treeNode;
        }
        if ((pathNodes = ((DefaultTreeModel)this.tree.getModel()).getPathToRoot(node)) == null) {
            return null;
        }
        return new TreePath(pathNodes);
    }

    private static List<TreePath> collectExpandedPaths(JTree tree) {
        TreePath root = tree.getPathForRow(0);
        Enumeration<TreePath> expandedDescendants = tree.getExpandedDescendants(root);
        if (expandedDescendants == null) {
            return Collections.emptyList();
        }
        ArrayList<TreePath> expandedPaths = new ArrayList<TreePath>();
        while (expandedDescendants.hasMoreElements()) {
            TreePath path = expandedDescendants.nextElement();
            if (path.getPathCount() <= 1) continue;
            expandedPaths.add(path);
        }
        expandedPaths.sort(PATH_LENGTH_REVERSE);
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        for (TreePath path : expandedPaths) {
            if (TreeExpansionService.isSubPath(result, path)) continue;
            result.add(path);
        }
        return result;
    }

    private static boolean isSubPath(List<TreePath> paths, TreePath path) {
        for (TreePath addedPath : paths) {
            if (!path.isDescendant(addedPath)) continue;
            return true;
        }
        return false;
    }

    private RootNode getRoot() {
        return this.mainWindow.getWrapper().getDecompiler().getRoot();
    }

    private static /* synthetic */ String lambda$resolveTreePath$7(TreeNode n) {
        return ((JNode)n).getID();
    }
}

