/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea;

import jadx.api.JavaNode;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.codearea.CodeArea;
import jadx.gui.utils.JumpPosition;
import java.util.Objects;
import javax.swing.event.HyperlinkEvent;
import org.fife.ui.rsyntaxtextarea.LinkGenerator;
import org.fife.ui.rsyntaxtextarea.LinkGeneratorResult;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeLinkGenerator
implements LinkGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(CodeLinkGenerator.class);
    private final CodeArea codeArea;
    private final JNode jNode;

    public CodeLinkGenerator(CodeArea codeArea) {
        this.codeArea = codeArea;
        this.jNode = codeArea.getNode();
    }

    public JavaNode getNodeAtOffset(int offset) {
        try {
            if (!this.codeArea.getCodeInfo().hasMetadata()) {
                return null;
            }
            int sourceOffset = this.codeArea.adjustOffsetForWordToken(offset);
            if (sourceOffset == -1) {
                return null;
            }
            return this.codeArea.getJavaNodeAtOffset(offset);
        }
        catch (Exception e) {
            LOG.error("getNodeAtOffset error", (Throwable)e);
            return null;
        }
    }

    public LinkGeneratorResult isLinkAtOffset(RSyntaxTextArea textArea, int offset) {
        try {
            if (!this.codeArea.getCodeInfo().hasMetadata()) {
                return null;
            }
            final int sourceOffset = this.codeArea.adjustOffsetForWordToken(offset);
            if (sourceOffset == -1) {
                return null;
            }
            final JumpPosition defPos = this.getJumpBySourceOffset(sourceOffset);
            if (defPos == null) {
                return null;
            }
            return new LinkGeneratorResult(){

                public HyperlinkEvent execute() {
                    return new HyperlinkEvent(defPos, HyperlinkEvent.EventType.ACTIVATED, null, defPos.getNode().makeLongString());
                }

                public int getSourceOffset() {
                    return sourceOffset;
                }
            };
        }
        catch (Exception e) {
            LOG.error("isLinkAtOffset error", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private JumpPosition getJumpBySourceOffset(int sourceOffset) {
        JumpPosition defPos = this.codeArea.getDefPosForNodeAtOffset(sourceOffset);
        if (defPos == null) {
            return null;
        }
        if (Objects.equals(defPos.getNode().getRootClass(), this.jNode) && defPos.getPos() == sourceOffset) {
            return null;
        }
        return defPos;
    }
}

