/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.dialog;

import ch.qos.logback.classic.Level;
import jadx.gui.logs.LogOptions;
import jadx.gui.treemodel.JNode;
import jadx.gui.treemodel.JResSearchNode;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.codearea.AbstractCodeArea;
import jadx.gui.ui.panel.ProgressPanel;
import jadx.gui.ui.tab.TabsController;
import jadx.gui.utils.CacheObject;
import jadx.gui.utils.JNodeCache;
import jadx.gui.utils.JumpPosition;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import jadx.gui.utils.ui.NodeLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonSearchDialog
extends JFrame {
    private static final Logger LOG = LoggerFactory.getLogger(CommonSearchDialog.class);
    private static final long serialVersionUID = 8939332306115370276L;
    protected final transient TabsController tabsController;
    protected final transient CacheObject cache;
    protected final transient MainWindow mainWindow;
    protected final transient Font codeFont;
    protected final transient String windowTitle;
    protected ResultsModel resultsModel;
    protected ResultsTable resultsTable;
    protected JLabel resultsInfoLabel;
    protected JLabel progressInfoLabel;
    protected JLabel warnLabel;
    protected ProgressPanel progressPane;
    private SearchContext highlightContext;

    public CommonSearchDialog(MainWindow mainWindow, String title) {
        this.mainWindow = mainWindow;
        this.tabsController = mainWindow.getTabsController();
        this.cache = mainWindow.getCacheObject();
        this.codeFont = mainWindow.getSettings().getFont();
        this.windowTitle = title;
        UiUtils.setWindowIcons(this);
        this.updateTitle("");
    }

    protected abstract void openInit();

    protected abstract void loadFinished();

    protected abstract void loadStart();

    public void loadWindowPos() {
        if (!this.mainWindow.getSettings().loadWindowPos(this)) {
            this.setSize(800, 500);
        }
    }

    private void updateTitle(String searchText) {
        if (searchText == null || searchText.isEmpty() || searchText.trim().isEmpty()) {
            this.setTitle(this.windowTitle);
        } else {
            this.setTitle(this.windowTitle + ": " + searchText);
        }
    }

    public void updateHighlightContext(String text, boolean caseSensitive, boolean regexp, boolean wholeWord) {
        this.updateTitle(text);
        this.highlightContext = new SearchContext(text);
        this.highlightContext.setMatchCase(caseSensitive);
        this.highlightContext.setWholeWord(wholeWord);
        this.highlightContext.setRegularExpression(regexp);
        this.highlightContext.setMarkAll(true);
    }

    public void disableHighlight() {
        this.highlightContext = null;
    }

    protected void registerInitOnOpen() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                SwingUtilities.invokeLater(CommonSearchDialog.this::openInit);
            }
        });
    }

    protected void openSelectedItem() {
        JNode node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        this.openItem(node);
    }

    protected void openItem(JNode node) {
        if (node instanceof JResSearchNode) {
            JumpPosition jmpPos = new JumpPosition(((JResSearchNode)node).getResNode(), node.getPos());
            this.tabsController.codeJump(jmpPos);
        } else {
            this.tabsController.codeJump(node);
        }
        if (!this.mainWindow.getSettings().getKeepCommonDialogOpen()) {
            this.dispose();
        }
    }

    @Nullable
    private JNode getSelectedNode() {
        try {
            int selectedId = this.resultsTable.getSelectedRow();
            if (selectedId == -1 || selectedId >= this.resultsTable.getRowCount()) {
                return null;
            }
            return (JNode)this.resultsModel.getValueAt(selectedId, 0);
        }
        catch (Exception e) {
            LOG.error("Failed to get results table selected object", (Throwable)e);
            return null;
        }
    }

    @Override
    public void dispose() {
        this.mainWindow.getSettings().saveWindowPos(this);
        super.dispose();
    }

    protected void initCommon() {
        UiUtils.addEscapeShortCutToDispose(this);
    }

    protected void copyAllSearchResults() {
        StringBuilder sb = new StringBuilder();
        HashSet<String> uniqueRefs = new HashSet<String>();
        for (JNode node : this.resultsModel.rows) {
            String codeNodeRef = node.getJavaNode().getCodeNodeRef().toString();
            if (!uniqueRefs.add(codeNodeRef)) continue;
            sb.append(codeNodeRef).append("\n");
        }
        UiUtils.copyToClipboard(sb.toString());
    }

    @NotNull
    protected JPanel initButtonsPanel() {
        this.progressPane = new ProgressPanel(this.mainWindow, false);
        JButton cancelButton = new JButton(NLS.str("search_dialog.cancel"));
        cancelButton.addActionListener(event -> this.dispose());
        JButton openBtn = new JButton(NLS.str("search_dialog.open"));
        openBtn.addActionListener(event -> this.openSelectedItem());
        this.getRootPane().setDefaultButton(openBtn);
        JButton copyBtn = new JButton(NLS.str("search_dialog.copy"));
        copyBtn.addActionListener(event -> this.copyAllSearchResults());
        JCheckBox cbKeepOpen = new JCheckBox(NLS.str("search_dialog.keep_open"));
        cbKeepOpen.setSelected(this.mainWindow.getSettings().getKeepCommonDialogOpen());
        cbKeepOpen.addActionListener(e -> {
            this.mainWindow.getSettings().setKeepCommonDialogOpen(cbKeepOpen.isSelected());
            this.mainWindow.getSettings().sync();
        });
        cbKeepOpen.setAlignmentY(0.5f);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.add(cbKeepOpen);
        buttonPane.add(Box.createRigidArea(new Dimension(15, 0)));
        buttonPane.add(this.progressPane);
        buttonPane.add(Box.createRigidArea(new Dimension(5, 0)));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(copyBtn);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(openBtn);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(cancelButton);
        return buttonPane;
    }

    protected JPanel initResultsTable() {
        ResultsTableCellRenderer renderer = new ResultsTableCellRenderer();
        this.resultsModel = new ResultsModel();
        this.resultsModel.addTableModelListener(e -> this.updateProgressLabel(false));
        this.resultsTable = new ResultsTable(this.resultsModel, renderer);
        this.resultsTable.setShowHorizontalLines(false);
        this.resultsTable.setDragEnabled(false);
        this.resultsTable.setSelectionMode(0);
        this.resultsTable.setColumnSelectionAllowed(false);
        this.resultsTable.setAutoResizeMode(0);
        this.resultsTable.setAutoscrolls(false);
        this.resultsTable.setDefaultRenderer(Object.class, renderer);
        Enumeration<TableColumn> columns = this.resultsTable.getColumnModel().getColumns();
        while (columns.hasMoreElements()) {
            TableColumn column = columns.nextElement();
            column.setCellRenderer(renderer);
        }
        this.resultsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    CommonSearchDialog.this.openSelectedItem();
                }
            }
        });
        this.resultsTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    CommonSearchDialog.this.openSelectedItem();
                }
            }
        });
        this.resultsTable.getActionMap().put("copy", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JNode selectedNode = CommonSearchDialog.this.getSelectedNode();
                if (selectedNode != null) {
                    UiUtils.copyToClipboard(selectedNode.makeLongString());
                }
            }
        });
        this.warnLabel = new JLabel();
        this.warnLabel.setForeground(Color.RED);
        this.warnLabel.setVisible(false);
        JScrollPane scroll = new JScrollPane(this.resultsTable, 20, 30);
        this.resultsInfoLabel = new JLabel("");
        this.resultsInfoLabel.setFont(this.mainWindow.getSettings().getFont());
        this.progressInfoLabel = new JLabel("");
        this.progressInfoLabel.setFont(this.mainWindow.getSettings().getFont());
        this.progressInfoLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CommonSearchDialog.this.mainWindow.showLogViewer(LogOptions.allWithLevel(Level.INFO));
            }
        });
        JPanel resultsActionsPanel = new JPanel();
        resultsActionsPanel.setLayout(new BoxLayout(resultsActionsPanel, 2));
        resultsActionsPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        this.addResultsActions(resultsActionsPanel);
        JPanel resultsPanel = new JPanel();
        resultsPanel.setLayout(new BoxLayout(resultsPanel, 3));
        resultsPanel.add((Component)this.warnLabel, "First");
        resultsPanel.add((Component)scroll, "Center");
        resultsPanel.add((Component)resultsActionsPanel, "Last");
        return resultsPanel;
    }

    protected void addResultsActions(JPanel resultsActionsPanel) {
        resultsActionsPanel.add(Box.createRigidArea(new Dimension(20, 0)));
        resultsActionsPanel.add(this.resultsInfoLabel);
        resultsActionsPanel.add(Box.createRigidArea(new Dimension(20, 0)));
        resultsActionsPanel.add(this.progressInfoLabel);
        resultsActionsPanel.add(Box.createHorizontalGlue());
    }

    protected void updateProgressLabel(boolean complete) {
        int count = this.resultsModel.getRowCount();
        String statusText = complete ? NLS.str("search_dialog.results_complete", count) : NLS.str("search_dialog.results_incomplete", count);
        this.resultsInfoLabel.setText(statusText);
    }

    protected void showSearchState() {
        this.resultsInfoLabel.setText(NLS.str("search_dialog.tip_searching") + "...");
    }

    void progressStartCommon() {
        this.progressPane.setIndeterminate(true);
        this.progressPane.setVisible(true);
        this.warnLabel.setVisible(false);
    }

    void progressFinishedCommon() {
        this.progressPane.setVisible(false);
    }

    protected JNodeCache getNodeCache() {
        return this.mainWindow.getCacheObject().getNodeCache();
    }

    protected final class ResultsTableCellRenderer
    implements TableCellRenderer {
        private final NodeLabel label;
        private final RSyntaxTextArea codeArea;
        private final NodeLabel emptyLabel;
        private final Color codeSelectedColor;
        private final Color codeBackground;

        public ResultsTableCellRenderer() {
            this.codeArea = AbstractCodeArea.getDefaultArea(CommonSearchDialog.this.mainWindow);
            this.codeArea.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
            this.codeArea.setRows(1);
            this.codeBackground = this.codeArea.getBackground();
            this.codeSelectedColor = this.codeArea.getSelectionColor();
            this.label = new NodeLabel();
            this.label.setOpaque(true);
            this.label.setFont(this.codeArea.getFont());
            this.label.setHorizontalAlignment(2);
            this.emptyLabel = new NodeLabel();
            this.emptyLabel.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
            if (obj == null || table == null) {
                return this.emptyLabel;
            }
            Component comp = this.makeCell((JNode)obj, column);
            this.updateSelection(table, comp, column, isSelected);
            return comp;
        }

        private void updateSelection(JTable table, Component comp, int column, boolean isSelected) {
            if (column == 1) {
                if (isSelected) {
                    comp.setBackground(this.codeSelectedColor);
                } else {
                    comp.setBackground(this.codeBackground);
                }
            } else if (isSelected) {
                comp.setBackground(table.getSelectionBackground());
                comp.setForeground(table.getSelectionForeground());
            } else {
                comp.setBackground(table.getBackground());
                comp.setForeground(table.getForeground());
            }
        }

        private Component makeCell(JNode node, int column) {
            if (column == 0) {
                this.label.disableHtml(node.disableHtml());
                this.label.setText(node.makeLongStringHtml());
                this.label.setToolTipText(node.getTooltip());
                this.label.setIcon(node.getIcon());
                return this.label;
            }
            if (!node.hasDescString()) {
                return this.emptyLabel;
            }
            this.codeArea.setSyntaxEditingStyle(node.getSyntaxName());
            String descStr = node.makeDescString();
            this.codeArea.setText(descStr);
            this.codeArea.setColumns(descStr.length() + 1);
            if (CommonSearchDialog.this.highlightContext != null) {
                SearchEngine.markAll((RTextArea)this.codeArea, (SearchContext)CommonSearchDialog.this.highlightContext);
            }
            return this.codeArea;
        }

        public int getMaxRowHeight() {
            this.label.setText("Text");
            this.codeArea.setText("Text");
            return Math.max(this.getCompHeight(this.label), this.getCompHeight((Component)this.codeArea));
        }

        private int getCompHeight(Component comp) {
            return Math.max(comp.getHeight(), comp.getPreferredSize().height);
        }
    }

    protected static final class ResultsModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -7821286846923903208L;
        private static final String[] COLUMN_NAMES = new String[]{NLS.str("search_dialog.col_node"), NLS.str("search_dialog.col_code")};
        private final transient List<JNode> rows = new ArrayList<JNode>();
        private transient boolean addDescColumn;

        protected ResultsModel() {
        }

        public void addAll(Collection<? extends JNode> nodes) {
            this.rows.addAll(nodes);
            if (!this.addDescColumn) {
                for (JNode row : this.rows) {
                    if (!row.hasDescString()) continue;
                    this.addDescColumn = true;
                    break;
                }
            }
        }

        public void clear() {
            this.addDescColumn = false;
            this.rows.clear();
        }

        public void sort() {
            Collections.sort(this.rows);
        }

        public boolean isAddDescColumn() {
            return this.addDescColumn;
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int index) {
            return COLUMN_NAMES[index];
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.rows.get(rowIndex);
        }
    }

    protected static final class ResultsTable
    extends JTable {
        private static final long serialVersionUID = 3901184054736618969L;
        private final transient ResultsModel model;

        public ResultsTable(ResultsModel resultsModel, ResultsTableCellRenderer renderer) {
            super(resultsModel);
            this.model = resultsModel;
            this.setRowHeight(renderer.getMaxRowHeight());
        }

        public void initColumnWidth() {
            int columnCount = this.getColumnCount();
            int width = this.getParent().getWidth();
            int colWidth = this.model.isAddDescColumn() ? width / 2 : width;
            this.columnModel.getColumn(0).setPreferredWidth(colWidth);
            for (int col = 1; col < columnCount; ++col) {
                this.columnModel.getColumn(col).setPreferredWidth(width);
            }
        }

        public void updateTable() {
            UiUtils.uiThreadGuard();
            int rowCount = this.getRowCount();
            if (rowCount == 0) {
                this.updateUI();
                return;
            }
            long start = System.currentTimeMillis();
            int width = this.getParent().getWidth();
            TableColumn firstColumn = this.columnModel.getColumn(0);
            if (this.model.isAddDescColumn()) {
                if ((double)firstColumn.getWidth() > (double)width * 0.8) {
                    firstColumn.setPreferredWidth(width / 2);
                }
                TableColumn secondColumn = this.columnModel.getColumn(1);
                int columnMaxWidth = width * 2;
                if (secondColumn.getWidth() < columnMaxWidth) {
                    secondColumn.setPreferredWidth(columnMaxWidth);
                }
            } else {
                firstColumn.setPreferredWidth(width);
            }
            this.updateUI();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Update results table in {}ms, count: {}", (Object)(System.currentTimeMillis() - start), (Object)rowCount);
            }
        }

        @Override
        public Object getValueAt(int row, int column) {
            return this.model.getValueAt(row, column);
        }
    }
}

