/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.tab.dnd;

import jadx.gui.ui.tab.dnd.TabDndController;
import jadx.gui.ui.tab.dnd.TabDndSourceListener;
import jadx.gui.ui.tab.dnd.TabDndTransferable;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.InvalidDnDOperationException;

public class TabDndGestureListener
implements DragGestureListener {
    private final transient TabDndController dnd;

    public TabDndGestureListener(TabDndController dnd) {
        this.dnd = dnd;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        Point tabPt = this.getDragOrigin(e);
        if (!this.dnd.onStartDrag(tabPt)) {
            return;
        }
        try {
            e.startDrag(DragSource.DefaultMoveDrop, new TabDndTransferable(), new TabDndSourceListener(this.dnd));
        }
        catch (InvalidDnDOperationException ex) {
            throw new IllegalStateException(ex);
        }
    }

    protected Point getDragOrigin(DragGestureEvent e) {
        return e.getDragOrigin();
    }
}

