/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils;

import jadx.gui.utils.SystemInfo;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Link
extends JLabel {
    private static final long serialVersionUID = 3655322136444908178L;
    private static final Logger LOG = LoggerFactory.getLogger(Link.class);
    private String url;

    public Link() {
        this.init();
    }

    public Link(String text, String url) {
        super(text);
        this.init();
        this.setUrl(url);
    }

    private void init() {
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Link.this.browse();
            }
        });
    }

    public void setUrl(String url) {
        this.url = url;
        this.setToolTipText("Open " + url + " in your browser");
    }

    private void browse() {
        Desktop desktop;
        if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(new URI(this.url));
                return;
            }
            catch (Exception e) {
                LOG.debug("Open url error", (Throwable)e);
            }
        }
        try {
            if (SystemInfo.IS_WINDOWS) {
                new ProcessBuilder(new String[0]).command("rundll32", "url.dll,FileProtocolHandler", this.url).start();
                return;
            }
            if (SystemInfo.IS_MAC) {
                new ProcessBuilder(new String[0]).command("open", this.url).start();
                return;
            }
            Map<String, String> env = System.getenv();
            if (env.get("BROWSER") != null) {
                new ProcessBuilder(new String[0]).command(env.get("BROWSER"), this.url).start();
                return;
            }
        }
        catch (Exception e) {
            LOG.debug("Open url error", (Throwable)e);
        }
        this.showUrlDialog();
    }

    private void showUrlDialog() {
        JTextArea urlArea = new JTextArea("Can't open browser. Please browse to:\n" + this.url);
        JOptionPane.showMessageDialog(null, urlArea);
    }
}

