/*
 * Decompiled with CFR 0.152.
 */
package jadx.api.plugins.input.data;

import jadx.api.plugins.input.data.AccessFlagsScope;

public class AccessFlags {
    public static final int PUBLIC = 1;
    public static final int PRIVATE = 2;
    public static final int PROTECTED = 4;
    public static final int STATIC = 8;
    public static final int FINAL = 16;
    public static final int SYNCHRONIZED = 32;
    public static final int SUPER = 32;
    public static final int VOLATILE = 64;
    public static final int BRIDGE = 64;
    public static final int TRANSIENT = 128;
    public static final int VARARGS = 128;
    public static final int NATIVE = 256;
    public static final int INTERFACE = 512;
    public static final int ABSTRACT = 1024;
    public static final int STRICT = 2048;
    public static final int SYNTHETIC = 4096;
    public static final int ANNOTATION = 8192;
    public static final int ENUM = 16384;
    public static final int MODULE = 32768;
    public static final int CONSTRUCTOR = 65536;
    public static final int DECLARED_SYNCHRONIZED = 131072;
    public static final int DATA = 262144;

    public static boolean hasFlag(int flags, int flagValue) {
        return (flags & flagValue) != 0;
    }

    public static String format(int flags, AccessFlagsScope scope) {
        StringBuilder code = new StringBuilder();
        if (AccessFlags.hasFlag(flags, 1)) {
            code.append("public ");
        }
        if (AccessFlags.hasFlag(flags, 2)) {
            code.append("private ");
        }
        if (AccessFlags.hasFlag(flags, 4)) {
            code.append("protected ");
        }
        if (AccessFlags.hasFlag(flags, 8)) {
            code.append("static ");
        }
        if (AccessFlags.hasFlag(flags, 16)) {
            code.append("final ");
        }
        if (AccessFlags.hasFlag(flags, 1024)) {
            code.append("abstract ");
        }
        if (AccessFlags.hasFlag(flags, 256)) {
            code.append("native ");
        }
        switch (scope) {
            case METHOD: {
                if (AccessFlags.hasFlag(flags, 32)) {
                    code.append("synchronized ");
                }
                if (AccessFlags.hasFlag(flags, 64)) {
                    code.append("bridge ");
                }
                if (!AccessFlags.hasFlag(flags, 128)) break;
                code.append("varargs ");
                break;
            }
            case FIELD: {
                if (AccessFlags.hasFlag(flags, 64)) {
                    code.append("volatile ");
                }
                if (!AccessFlags.hasFlag(flags, 128)) break;
                code.append("transient ");
                break;
            }
            case CLASS: {
                if (AccessFlags.hasFlag(flags, 32768)) {
                    code.append("module ");
                }
                if (AccessFlags.hasFlag(flags, 2048)) {
                    code.append("strict ");
                }
                if (AccessFlags.hasFlag(flags, 32)) {
                    code.append("super ");
                }
                if (AccessFlags.hasFlag(flags, 16384)) {
                    code.append("enum ");
                }
                if (!AccessFlags.hasFlag(flags, 262144)) break;
                code.append("data ");
            }
        }
        if (AccessFlags.hasFlag(flags, 4096)) {
            code.append("synthetic ");
        }
        return code.toString();
    }
}

