/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.javaconvert;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertResult
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ConvertResult.class);
    private final List<Path> converted = new ArrayList<Path>();
    private final List<Path> tmpPaths = new ArrayList<Path>();

    public List<Path> getConverted() {
        return this.converted;
    }

    public void addConvertedFiles(List<Path> paths) {
        this.converted.addAll(paths);
    }

    public void addTempPath(Path path) {
        this.tmpPaths.add(path);
    }

    public boolean isEmpty() {
        return this.converted.isEmpty();
    }

    @Override
    public void close() {
        for (Path tmpPath : this.tmpPaths) {
            try {
                ConvertResult.delete(tmpPath);
            }
            catch (Exception e) {
                LOG.warn("Failed to delete temp path: {}", (Object)tmpPath, (Object)e);
            }
        }
    }

    private static void delete(Path path) throws IOException {
        if (Files.isRegularFile(path, new LinkOption[0])) {
            Files.delete(path);
            return;
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (Stream<Path> pathStream = Files.walk(path, new FileVisitOption[0]);){
                pathStream.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
        }
    }

    public String toString() {
        return "ConvertResult{converted=" + String.valueOf(this.converted) + ", tmpPaths=" + String.valueOf(this.tmpPaths) + "}";
    }
}

