/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.java;

import jadx.api.plugins.input.data.IClassData;
import jadx.api.plugins.input.data.ILoadResult;
import jadx.api.plugins.input.data.IResourceData;
import jadx.plugins.input.java.JavaClassReader;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaLoadResult
implements ILoadResult {
    private static final Logger LOG = LoggerFactory.getLogger(JavaLoadResult.class);
    private final List<JavaClassReader> readers;
    @Nullable
    private final Closeable closeable;

    public JavaLoadResult(List<JavaClassReader> readers, @Nullable Closeable closeable) {
        this.readers = readers;
        this.closeable = closeable;
    }

    public void visitClasses(Consumer<IClassData> consumer) {
        for (JavaClassReader reader : this.readers) {
            try {
                consumer.accept(reader.loadClassData());
            }
            catch (Exception e) {
                LOG.error("Failed to load class data for file: " + reader.getFileName(), (Throwable)e);
            }
        }
    }

    public void visitResources(Consumer<IResourceData> consumer) {
    }

    public boolean isEmpty() {
        return this.readers.isEmpty();
    }

    public void close() throws IOException {
        this.readers.clear();
        if (this.closeable != null) {
            this.closeable.close();
        }
    }
}

