/*
 * Decompiled with CFR 0.152.
 */
package jadx.api.plugins.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class CommonFileUtils {
    public static final File CWD = CommonFileUtils.getCWD();
    public static final Path CWD_PATH = CWD.toPath();

    private static File getCWD() {
        try {
            return new File(".").getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to init current working dir constant", e);
        }
    }

    public static Path saveToTempFile(InputStream in, String suffix) throws IOException {
        return CommonFileUtils.saveToTempFile(null, in, suffix);
    }

    public static Path saveToTempFile(byte[] dataPrefix, InputStream in, String suffix) throws IOException {
        Path tempFile = Files.createTempFile("jadx-temp-", suffix, new FileAttribute[0]);
        try (OutputStream out = Files.newOutputStream(tempFile, new OpenOption[0]);){
            if (dataPrefix != null) {
                out.write(dataPrefix);
            }
            CommonFileUtils.copyStream(in, out);
        }
        catch (Exception e) {
            throw new IOException("Failed to save temp file", e);
        }
        return tempFile;
    }

    public static byte[] loadBytes(InputStream input) throws IOException {
        return CommonFileUtils.loadBytes(null, input);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] loadBytes(byte[] dataPrefix, InputStream in) throws IOException {
        int estimateSize = dataPrefix == null ? in.available() : dataPrefix.length + in.available();
        try (ByteArrayOutputStream out = new ByteArrayOutputStream(estimateSize);){
            if (dataPrefix != null) {
                out.write(dataPrefix);
            }
            CommonFileUtils.copyStream(in, out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new IOException("Failed to read input stream to bytes array", e);
        }
    }

    public static void copyStream(InputStream input, OutputStream output) throws IOException {
        int count;
        byte[] buffer = new byte[8192];
        while ((count = input.read(buffer)) != -1) {
            output.write(buffer, 0, count);
        }
    }
}

