/*
 * Decompiled with CFR 0.152.
 */
package jadx.zip;

import jadx.zip.IZipEntry;
import jadx.zip.IZipParser;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class ZipContent
implements Closeable {
    private final IZipParser zipParser;
    private final List<IZipEntry> entries;
    private final Map<String, IZipEntry> entriesMap;

    public ZipContent(IZipParser zipParser, List<IZipEntry> entries) {
        this.zipParser = zipParser;
        this.entries = entries;
        this.entriesMap = entries.stream().collect(Collectors.toMap(IZipEntry::getName, Function.identity()));
    }

    public List<IZipEntry> getEntries() {
        return this.entries;
    }

    @Nullable
    public IZipEntry searchEntry(String fileName) {
        return this.entriesMap.get(fileName);
    }

    @Override
    public void close() throws IOException {
        this.zipParser.close();
    }
}

