/*
 * Decompiled with CFR 0.152.
 */
package jadx.zip.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferBackedInputStream
extends InputStream {
    private final ByteBuffer buf;
    private int markedPosition = 0;

    public ByteBufferBackedInputStream(ByteBuffer buf) {
        this.buf = buf;
    }

    @Override
    public int read() throws IOException {
        if (!this.buf.hasRemaining()) {
            return -1;
        }
        return this.buf.get() & 0xFF;
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        if (!this.buf.hasRemaining()) {
            return -1;
        }
        int readLen = Math.min(len, this.buf.remaining());
        this.buf.get(bytes, off, readLen);
        return readLen;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int unused) {
        this.markedPosition = this.buf.position();
    }

    @Override
    public synchronized void reset() {
        this.buf.position(this.markedPosition);
    }
}

