/*
 * Decompiled with CFR 0.152.
 */
package io.github.skylot.raung.asm.impl;

import io.github.skylot.raung.asm.impl.RaungAsmBuilder;
import io.github.skylot.raung.asm.impl.asm.RaungAsmWriter;
import io.github.skylot.raung.asm.impl.parser.RaungParser;
import io.github.skylot.raung.asm.impl.parser.data.ClassData;
import io.github.skylot.raung.asm.impl.utils.RaungAsmException;
import io.github.skylot.raung.asm.impl.utils.ValidateAsmArgs;
import io.github.skylot.raung.common.utils.FileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaungAsmExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(RaungAsmExecutor.class);

    public static void process(RaungAsmBuilder args) {
        ValidateAsmArgs.process(args);
        String ext = FileUtils.getExt((Path)args.getOutput());
        if (ext == null) {
            RaungAsmExecutor.saveToDir(args);
        } else {
            switch (ext) {
                case "jar": {
                    RaungAsmExecutor.saveToJar(args);
                    break;
                }
                case "class": {
                    RaungAsmExecutor.saveToClass(args);
                }
            }
        }
    }

    public static byte[] processSingleClass(RaungAsmBuilder args, Path inputPath) {
        FileUtils.checkInputFile((Path)inputPath);
        ValidateAsmArgs.processOptions(args);
        return RaungAsmExecutor.runForSingleClass(args, inputPath).getBytes();
    }

    public static byte[] processInputStream(RaungAsmBuilder args, InputStream input, @Nullable String fileName) {
        ValidateAsmArgs.processOptions(args);
        return RaungAsmExecutor.runForInputStream(args, input, fileName).getBytes();
    }

    /*
     * Exception decompiling
     */
    public static ClassData runForSingleClass(RaungAsmBuilder args, Path inputPath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ClassData runForInputStream(RaungAsmBuilder args, InputStream input, @Nullable String fileName) {
        try (RaungParser parser = new RaungParser(args, input, fileName);){
            ClassData classData = RaungAsmWriter.buildCls(parser.parse());
            return classData;
        }
        catch (IOException e) {
            throw new RaungAsmException("Failed to assemble input", e);
        }
    }

    private static void saveToDir(RaungAsmBuilder args) {
        throw new RaungAsmException("Not implemented yet");
    }

    private static void saveToClass(RaungAsmBuilder args) {
        Path input = args.getInputs().get(0);
        try {
            byte[] bytes = RaungAsmExecutor.runForSingleClass(args, input).getBytes();
            Files.write(args.getOutput(), bytes, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        }
        catch (Exception e) {
            throw new RaungAsmException("Failed to save class file from " + input.toAbsolutePath(), e);
        }
    }

    private static void saveToJar(RaungAsmBuilder args) {
        Path jarPath = args.getOutput();
        LOG.info("Saving to jar: {}", (Object)jarPath);
        try (JarOutputStream jar = new JarOutputStream(Files.newOutputStream(args.getOutput(), new OpenOption[0]));){
            for (Path input : args.getInputs()) {
                RaungAsmExecutor.processInputForJar(input, jar, args);
            }
        }
        catch (IOException e) {
            throw new RaungAsmException("Process failed", e);
        }
    }

    private static void processInputForJar(Path input, JarOutputStream jar, RaungAsmBuilder args) throws IOException {
        Path resources = input.resolve("resources");
        boolean checkResources = Files.isDirectory(resources, new LinkOption[0]);
        for (Path file : FileUtils.expandDir((Path)input)) {
            JarEntry entry;
            String ext = FileUtils.getExt((Path)file);
            if (Objects.equals(ext, "raung")) {
                ClassData cls = RaungAsmExecutor.runForSingleClass(args, file);
                entry = new JarEntry(cls.getName() + ".class");
                jar.putNextEntry(entry);
                jar.write(cls.getBytes());
                jar.closeEntry();
                continue;
            }
            if (!checkResources || !file.startsWith(resources)) continue;
            Path resFile = resources.relativize(file);
            entry = new JarEntry(resFile.toString());
            jar.putNextEntry(entry);
            jar.write(Files.readAllBytes(file));
            jar.closeEntry();
        }
    }
}

