/*
 * Decompiled with CFR 0.152.
 */
package io.github.skylot.raung.asm.impl.parser;

import io.github.skylot.raung.asm.impl.utils.RaungAsmException;
import io.github.skylot.raung.common.utils.StringCommonUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RaungTokenizer
implements Closeable {
    private final Reader reader;
    private final StringBuilder lineBuffer = new StringBuilder();
    private final StringBuilder tokenBuffer = new StringBuilder();
    private State savedState = State.NONE;
    private int line = 1;
    private int column = 1;

    public RaungTokenizer(InputStream in) {
        this.reader = new BufferedReader(new InputStreamReader(in));
    }

    public String getToken() {
        return this.tokenBuffer.toString();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TokenType next() {
        StringBuilder buf = this.tokenBuffer;
        buf.setLength(0);
        TokenType returnType = this.processSavedState();
        if (returnType != null) {
            return returnType;
        }
        State state = this.savedState;
        try {
            block8: while (true) {
                int cp;
                if ((cp = this.reader.read()) == -1) {
                    if (state == State.TOKEN) {
                        this.savedState = State.AT_FILE_END;
                        return TokenType.TOKEN;
                    }
                    return TokenType.FILE_END;
                }
                ++this.column;
                this.lineBuffer.appendCodePoint(cp);
                switch (cp) {
                    case 10: 
                    case 13: {
                        return this.processEndLine(state, cp);
                    }
                    case 35: {
                        if ((state = this.processComment(buf, state)) != null) continue block8;
                        return TokenType.TOKEN;
                    }
                    case 34: {
                        if (state == State.COMMENT) continue block8;
                        buf.append('\"');
                        if (state == State.STRING) {
                            this.savedState = State.NONE;
                            return TokenType.TOKEN;
                        }
                        state = State.STRING;
                        continue block8;
                    }
                    case 92: {
                        if (state == State.STRING_ESCAPE) {
                            buf.append("\\\\");
                            state = State.STRING;
                            continue block8;
                        }
                        state = State.STRING_ESCAPE;
                        continue block8;
                    }
                }
                if ((state = this.appendChar(buf, state, cp)) == null) break;
            }
            return TokenType.TOKEN;
        }
        catch (IOException e) {
            throw new RaungAsmException("Read error", e);
        }
    }

    @Nullable
    private TokenType processSavedState() {
        switch (this.savedState) {
            case AT_FILE_END: {
                this.savedState = State.NONE;
                return TokenType.FILE_END;
            }
            case AT_LINE_END: {
                this.savedState = State.NONE;
                this.newLine();
                return TokenType.LINE_END;
            }
            case AT_ASSIGN: {
                this.savedState = State.NONE;
                this.tokenBuffer.append('=');
                return TokenType.TOKEN;
            }
        }
        return null;
    }

    @NotNull
    private TokenType processEndLine(State state, int cp) throws IOException {
        this.consumeCharIf(cp == 10 ? (char)'\r' : '\n');
        switch (state) {
            case COMMENT: {
                this.savedState = State.AT_LINE_END;
                return TokenType.LINE_END;
            }
            case TOKEN: {
                this.savedState = State.AT_LINE_END;
                return TokenType.TOKEN;
            }
        }
        this.newLine();
        return TokenType.LINE_END;
    }

    @Nullable
    private State processComment(StringBuilder buf, State state) {
        if (state == State.TOKEN) {
            this.savedState = State.COMMENT;
            return null;
        }
        if (state == State.STRING) {
            buf.append('#');
            return state;
        }
        return State.COMMENT;
    }

    @Nullable
    private State appendChar(StringBuilder buf, State state, int cp) {
        boolean space;
        if (state == State.COMMENT) {
            return state;
        }
        if (state == State.STRING_ESCAPE) {
            buf.append('\\');
            state = State.STRING;
        }
        if (state == State.STRING) {
            if (cp < 255) {
                buf.append((char)cp);
            } else {
                buf.append(new String(Character.toChars(cp)));
            }
            return state;
        }
        if (cp < 255) {
            char ch = (char)cp;
            if (ch == '=') {
                if (state == State.TOKEN) {
                    this.savedState = State.AT_ASSIGN;
                    return null;
                }
                buf.append(ch);
                return null;
            }
            boolean bl = space = ch <= ' ';
            if (!space) {
                buf.append(ch);
            }
        } else {
            space = Character.isWhitespace(cp);
            if (!space) {
                buf.append(new String(Character.toChars(cp)));
            }
        }
        if (state == State.TOKEN) {
            if (space) {
                return null;
            }
        } else if (!space) {
            state = State.TOKEN;
        }
        return state;
    }

    private void newLine() {
        ++this.line;
        this.column = 1;
        this.lineBuffer.setLength(0);
    }

    private void consumeCharIf(char ch) throws IOException {
        Reader r = this.reader;
        r.mark(1);
        int cp = r.read();
        if (cp != ch) {
            r.reset();
        }
    }

    public String formatMsgForCurrentPosition(int offsetInToken, String msg, @Nullable String fileName) {
        int tokenLen = this.tokenBuffer.length();
        int lineOffset = this.column - tokenLen - 1 + offsetInToken;
        String lineNum = Integer.toString(this.line);
        String contextPadding = StringCommonUtils.repeat((char)' ', (int)(lineNum.length() + 1)) + '|';
        String markPadding = contextPadding + StringCommonUtils.repeat((char)' ', (int)(lineOffset - 1));
        return StringCommonUtils.repeat((char)' ', (int)(lineNum.length() + 1)) + "at " + fileName + ':' + lineNum + ':' + lineOffset + '\n' + contextPadding + '\n' + lineNum + " |" + this.readFullLine() + '\n' + markPadding + '^' + StringCommonUtils.repeat((char)'~', (int)(tokenLen - 1 - offsetInToken)) + '\n' + markPadding + msg + '\n';
    }

    private String readFullLine() {
        if (this.savedState == State.AT_LINE_END || this.savedState == State.AT_FILE_END) {
            return this.lineBuffer.toString().replaceAll("[\n\r]", "");
        }
        try {
            int cp;
            while ((cp = this.reader.read()) != -1 && cp != 10 && cp != 13) {
                this.lineBuffer.appendCodePoint(cp);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.lineBuffer.toString();
    }

    public static enum State {
        NONE,
        STRING,
        STRING_ESCAPE,
        COMMENT,
        TOKEN,
        AT_LINE_END,
        AT_FILE_END,
        AT_ASSIGN;

    }

    public static enum TokenType {
        LINE_END,
        FILE_END,
        TOKEN;

    }
}

