/*
 * Decompiled with CFR 0.152.
 */
package io.github.skylot.raung.asm.impl.parser.code;

import io.github.skylot.raung.asm.impl.asm.InsnAnnotationNode;
import io.github.skylot.raung.asm.impl.parser.RaungParser;
import io.github.skylot.raung.asm.impl.parser.code.ValueParser;
import io.github.skylot.raung.asm.impl.parser.data.CommonData;
import io.github.skylot.raung.asm.impl.parser.data.MethodData;
import io.github.skylot.raung.asm.impl.parser.data.TypeRefPathData;
import io.github.skylot.raung.asm.impl.utils.RaungAsmException;
import io.github.skylot.raung.common.AnnotationType;
import io.github.skylot.raung.common.Directive;
import io.github.skylot.raung.common.asm.TypeRef;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.TypeReference;

public class AnnotationParser {
    public static void process(RaungParser parser, CommonData data) {
        boolean visible = AnnotationParser.parseVisibility(parser);
        String type = parser.readType();
        AnnotationVisitor av = data.visitAnnotation(type, visible);
        AnnotationParser.parse(av, parser, AnnotationType.NORMAL);
    }

    public static void processParamAnnotation(RaungParser parser, MethodData methodData) {
        int parameter = parser.readInt();
        boolean visible = AnnotationParser.parseVisibility(parser);
        String type = parser.readType();
        AnnotationVisitor av = methodData.getAsmMethodVisitor().visitParameterAnnotation(parameter, type, visible);
        AnnotationParser.parse(av, parser, AnnotationType.PARAM);
    }

    public static void processTypeAnnotation(RaungParser parser, CommonData data) {
        boolean visible = AnnotationParser.parseVisibility(parser);
        String type = parser.readType();
        parser.lineEnd();
        TypeRefPathData pathData = AnnotationParser.parseRef(parser);
        int typeRefValue = pathData.getTypeRef().getValue();
        AnnotationVisitor av = data.visitTypeAnnotation(typeRefValue, pathData.getPath(), type, visible);
        AnnotationParser.parse(av, parser, AnnotationType.TYPE);
    }

    public static void processInsnAnnotation(RaungParser parser, MethodData methodData) {
        boolean visible = AnnotationParser.parseVisibility(parser);
        String type = parser.readType();
        parser.lineEnd();
        TypeRefPathData pathData = AnnotationParser.parseRef(parser);
        InsnAnnotationNode av = new InsnAnnotationNode(type, visible, pathData);
        AnnotationParser.parse((AnnotationVisitor)av, parser, AnnotationType.INSN);
        methodData.setAnnotationForNextInsn(av);
    }

    public static void processAnnotationDefaultValue(RaungParser parser, MethodData methodData) {
        parser.lineEnd();
        AnnotationVisitor av = methodData.getAsmMethodVisitor().visitAnnotationDefault();
        AnnotationParser.parseValue(av, parser, null);
        av.visitEnd();
        parser.lineEnd();
        parser.consumeToken(".end");
        parser.consumeToken(AnnotationType.DEFAULT.getName());
        parser.lineEnd();
    }

    private static boolean parseVisibility(RaungParser parser) {
        String visType;
        switch (visType = parser.readToken()) {
            case "runtime": {
                return true;
            }
            case "build": {
                return false;
            }
        }
        throw new RaungAsmException("Unknown annotation type '" + visType + "'. Expecting 'build' or 'runtime'");
    }

    private static void parse(AnnotationVisitor av, RaungParser parser, AnnotationType type) {
        while (true) {
            String nameToken;
            if ((nameToken = parser.skipToToken()) == null) {
                throw new RaungAsmException("Unexpected end of file");
            }
            if (nameToken.equals(Directive.END.token())) {
                parser.consumeToken(type.getName());
                av.visitEnd();
                parser.lineEnd();
                return;
            }
            if (nameToken.startsWith(".")) {
                AnnotationParser.processDirective(av, parser, nameToken);
            } else {
                parser.consumeToken("=");
                AnnotationParser.parseValue(av, parser, nameToken);
            }
            parser.lineEnd();
        }
    }

    private static void parseValue(AnnotationVisitor av, RaungParser parser, @Nullable String nameToken) {
        String valueToken = parser.readToken();
        if (valueToken.startsWith(".")) {
            AnnotationParser.processSubValue(av, parser, nameToken, valueToken);
        } else {
            av.visit(nameToken, ValueParser.process(valueToken));
        }
    }

    private static void processSubValue(AnnotationVisitor av, RaungParser parser, @Nullable String name, String valueToken) {
        switch (valueToken) {
            case ".enum": {
                String owner = parser.readType();
                String value = parser.readToken();
                av.visitEnum(name, owner, value);
                break;
            }
            case ".array": {
                parser.lineEnd();
                AnnotationVisitor arrayVisitor = av.visitArray(name);
                AnnotationParser.parseSubArray(arrayVisitor, parser);
                arrayVisitor.visitEnd();
                break;
            }
            default: {
                throw new RaungAsmException("Unknown annotation sub value directive", valueToken);
            }
        }
    }

    private static void processDirective(AnnotationVisitor av, RaungParser parser, String nameToken) {
        switch (nameToken) {
            default: 
        }
        throw new RaungAsmException("Unknown annotation directive", nameToken);
    }

    private static TypeRefPathData parseRef(RaungParser parser) {
        parser.consumeToken(".ref");
        String refType = parser.readToken();
        TypeRef ref = TypeRef.getByName((String)refType);
        if (ref == null) {
            throw new RaungAsmException("Unknown type reference sort", refType);
        }
        int sort = ref.getValue();
        TypeRefPathData path = new TypeRefPathData();
        AnnotationParser.parseTypeReference(parser, ref, sort, path);
        String token = parser.tryGetToken();
        if (token != null) {
            path.setPath(TypePath.fromString((String)token));
            parser.lineEnd();
        }
        return path;
    }

    private static void parseTypeReference(RaungParser parser, TypeRef ref, int sort, TypeRefPathData path) {
        switch (ref.getFormat()) {
            case NO_ARGS: {
                path.setTypeRef(TypeReference.newTypeReference((int)sort));
                break;
            }
            case TYPE_PARAM_INDEX: {
                path.setTypeRef(TypeReference.newTypeParameterReference((int)sort, (int)parser.readInt()));
                break;
            }
            case TYPE_PARAM_BOUND_INDEX: {
                path.setTypeRef(TypeReference.newTypeParameterBoundReference((int)sort, (int)parser.readInt(), (int)parser.readInt()));
                break;
            }
            case SUPER_TYPE_INDEX: {
                path.setTypeRef(TypeReference.newSuperTypeReference((int)parser.readInt()));
                break;
            }
            case FORMAL_PARAM_INDEX: {
                path.setTypeRef(TypeReference.newFormalParameterReference((int)parser.readInt()));
                break;
            }
            case EXCEPTION_INDEX: {
                path.setTypeRef(TypeReference.newExceptionReference((int)parser.readInt()));
                break;
            }
            case TRY_CATCH_BLOCK_INDEX: {
                path.setTypeRef(TypeReference.newTryCatchReference((int)parser.readInt()));
                break;
            }
            case TYPE_ARGUMENT_INDEX: {
                path.setTypeRef(TypeReference.newTypeArgumentReference((int)sort, (int)parser.readInt()));
            }
        }
    }

    private static void parseSubArray(AnnotationVisitor av, RaungParser parser) {
        while (true) {
            String token;
            if ((token = parser.readToken()).startsWith(".")) {
                if (token.equals(Directive.END.token())) {
                    parser.consumeToken("array");
                    return;
                }
                AnnotationParser.processSubValue(av, parser, null, token);
            } else {
                av.visit(null, ValueParser.process(token));
            }
            parser.lineEnd();
        }
    }
}

