/*
 * Decompiled with CFR 0.152.
 */
package io.github.skylot.raung.asm.impl.parser.code;

import io.github.skylot.raung.asm.impl.parser.RaungParser;
import io.github.skylot.raung.asm.impl.parser.data.MethodData;
import io.github.skylot.raung.asm.impl.parser.data.RaungLabel;
import io.github.skylot.raung.asm.impl.utils.RaungAsmException;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class SwitchParser {
    public static void parse(MethodData mth, MethodVisitor mv, RaungParser parser, String token) {
        parser.lineEnd();
        RaungLabel defLabel = null;
        ArrayList<Integer> keys = new ArrayList<Integer>();
        ArrayList<RaungLabel> labels = new ArrayList<RaungLabel>();
        while (true) {
            String key;
            if ((key = parser.skipToToken()) == null) {
                throw new RaungAsmException("Missing switch end");
            }
            if (key.equals(".end")) break;
            if (key.equals("default")) {
                defLabel = RaungLabel.ref(mth, parser.readToken());
                continue;
            }
            keys.add(Integer.parseInt(key));
            labels.add(RaungLabel.ref(mth, parser.readToken()));
        }
        parser.consumeToken(token);
        if (defLabel == null) {
            throw new RaungAsmException("'default' case is required in switch");
        }
        int[] keysArr = SwitchParser.toIntArray(keys);
        SwitchParser.check(keysArr);
        Label[] labelsArr = labels.toArray(new Label[0]);
        boolean canUseTableSwitch = SwitchParser.isTableSwitch(keysArr);
        boolean isTableSwitch = token.equals("tableswitch");
        if (isTableSwitch && !canUseTableSwitch) {
            throw new RaungAsmException("Can't use tableswitch, keys are not sequential");
        }
        boolean autoSwitch = token.equals("switch");
        if (isTableSwitch || autoSwitch && canUseTableSwitch) {
            int min = keysArr[0];
            int max = keysArr[keysArr.length - 1];
            mv.visitTableSwitchInsn(min, max, (Label)defLabel, labelsArr);
        } else {
            mv.visitLookupSwitchInsn((Label)defLabel, keysArr, labelsArr);
        }
    }

    private static boolean isTableSwitch(int[] keys) {
        int last = keys.length - 1;
        for (int i = 0; i < last; ++i) {
            int a = keys[i];
            int b = keys[i + 1];
            if (a + 1 == b) continue;
            return false;
        }
        return true;
    }

    private static int[] toIntArray(List<Integer> list) {
        int size = list.size();
        int[] arr = new int[size];
        for (int i = 0; i < size; ++i) {
            arr[i] = list.get(i);
        }
        return arr;
    }

    private static void check(int[] keys) {
        int last = keys.length - 1;
        for (int i = 0; i < last; ++i) {
            int a = keys[i];
            int b = keys[i + 1];
            if (a == b) {
                throw new RaungAsmException("Switch keys should be different: " + a);
            }
            if (a <= b) continue;
            throw new RaungAsmException("Switch keys should be sorted: " + a + " occur before " + b);
        }
    }
}

