/*
 * Decompiled with CFR 0.152.
 */
package io.github.skylot.raung.asm.impl.parser.code;

import io.github.skylot.raung.asm.impl.parser.utils.StringAsmUtils;
import io.github.skylot.raung.asm.impl.utils.RaungAsmException;
import org.objectweb.asm.Type;

public class ValueParser {
    public static Object process(String token) {
        char firstChar = token.charAt(0);
        if (firstChar == '\"') {
            return StringAsmUtils.unescapeString(token.substring(1, token.length() - 1));
        }
        if (firstChar == 'L') {
            return Type.getObjectType((String)token.substring(1, token.length() - 1));
        }
        if (firstChar == '-' || firstChar == '+' || Character.isDigit(firstChar)) {
            if (token.endsWith("L")) {
                return Long.parseLong(token.substring(0, token.length() - 1));
            }
            if (token.endsWith("f")) {
                return Float.valueOf(Float.parseFloat(token.substring(0, token.length() - 1)));
            }
            if (token.contains(".")) {
                return Double.parseDouble(token);
            }
            return Integer.parseInt(token);
        }
        int dotIdx = token.indexOf(46);
        if (dotIdx != -1) {
            if (dotIdx == token.length()) {
                throw new RaungAsmException("Unknown value format: " + token);
            }
            return ValueParser.parseSpecialValue(token.substring(0, dotIdx), token.substring(dotIdx + 1));
        }
        if (token.equals("true")) {
            return Boolean.TRUE;
        }
        if (token.equals("false")) {
            return Boolean.FALSE;
        }
        return Type.getObjectType((String)token);
    }

    private static Object parseSpecialValue(String type, String value) {
        switch (type) {
            case "Double": {
                return ValueParser.parseSpecialDouble(value);
            }
            case "Float": {
                return ValueParser.parseSpecialFloat(value);
            }
        }
        throw new RaungAsmException("Unknown special value: " + type + "." + value);
    }

    private static Object parseSpecialDouble(String value) {
        switch (value) {
            case "NaN": {
                return Double.NaN;
            }
            case "MAX_VALUE": {
                return Double.MAX_VALUE;
            }
            case "MIN_VALUE": {
                return Double.MIN_VALUE;
            }
            case "POSITIVE_INFINITY": {
                return Double.POSITIVE_INFINITY;
            }
            case "NEGATIVE_INFINITY": {
                return Double.NEGATIVE_INFINITY;
            }
        }
        throw new RaungAsmException("Unknown Double special value: " + value);
    }

    private static Object parseSpecialFloat(String value) {
        switch (value) {
            case "NaN": {
                return Float.valueOf(Float.NaN);
            }
            case "MAX_VALUE": {
                return Float.valueOf(Float.MAX_VALUE);
            }
            case "MIN_VALUE": {
                return Float.valueOf(Float.MIN_VALUE);
            }
            case "POSITIVE_INFINITY": {
                return Float.valueOf(Float.POSITIVE_INFINITY);
            }
            case "NEGATIVE_INFINITY": {
                return Float.valueOf(Float.NEGATIVE_INFINITY);
            }
        }
        throw new RaungAsmException("Unknown Float special value: " + value);
    }
}

