/*
 * Decompiled with CFR 0.152.
 */
package io.github.skylot.raung.asm.impl.parser.data;

import io.github.skylot.raung.asm.impl.asm.InsnAnnotationNode;
import io.github.skylot.raung.asm.impl.asm.RaungAsmWriter;
import io.github.skylot.raung.asm.impl.parser.data.ClassData;
import io.github.skylot.raung.asm.impl.parser.data.CommonData;
import io.github.skylot.raung.asm.impl.parser.data.RaungLabel;
import io.github.skylot.raung.asm.impl.parser.data.RaungLocalVar;
import io.github.skylot.raung.asm.impl.parser.data.TryCatchBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.TypePath;

public class MethodData
extends CommonData {
    private final ClassData classData;
    private String descriptor;
    private final List<String> throwsList = new ArrayList<String>();
    private int maxStack = 0;
    private int maxLocals = 0;
    private MethodVisitor methodVisitor;
    private int insnsCount = 0;
    private Map<Integer, RaungLocalVar> localVars;
    private final List<RaungLabel> labels = new ArrayList<RaungLabel>();
    private final List<TryCatchBlock> catchBlocks = new ArrayList<TryCatchBlock>();
    private final Map<String, RaungLabel> labelsMap = new HashMap<String, RaungLabel>();
    private InsnAnnotationNode insnAnnotationNode;

    public MethodData(ClassData classData) {
        this.classData = classData;
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    public void setMaxStack(int maxStack) {
        this.maxStack = maxStack;
    }

    public int getMaxLocals() {
        return this.maxLocals;
    }

    public void setMaxLocals(int maxLocals) {
        this.maxLocals = maxLocals;
    }

    public ClassData getClassData() {
        return this.classData;
    }

    public MethodVisitor getAsmMethodVisitor() {
        if (this.methodVisitor == null) {
            this.methodVisitor = RaungAsmWriter.visitMethod(this);
        }
        return this.methodVisitor;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(String descriptor) {
        this.descriptor = descriptor;
    }

    public List<String> getThrows() {
        return this.throwsList;
    }

    public void addThrow(String type) {
        this.throwsList.add(type);
    }

    public int getInsnsCount() {
        return this.insnsCount;
    }

    public void addInsn() {
        ++this.insnsCount;
        if (this.insnAnnotationNode != null) {
            RaungAsmWriter.attachInsnAnnotation(this, this.insnAnnotationNode);
            this.insnAnnotationNode = null;
        }
    }

    public void addLocalVar(RaungLocalVar localVar) {
        if (this.localVars == null) {
            this.localVars = new HashMap<Integer, RaungLocalVar>();
        }
        this.localVars.put(localVar.getNumber(), localVar);
    }

    @Nullable
    public RaungLocalVar getLocalVar(int number) {
        if (this.localVars == null) {
            return null;
        }
        return this.localVars.get(number);
    }

    public Collection<RaungLocalVar> getLocalVars() {
        if (this.localVars == null) {
            return Collections.emptyList();
        }
        return this.localVars.values();
    }

    public void addLabel(RaungLabel label) {
        this.labels.add(label);
        this.labelsMap.put(label.getName(), label);
    }

    @Nullable
    public RaungLabel getLabel(String name) {
        return this.labelsMap.get(name);
    }

    @Nullable
    public RaungLabel getLabel(int pos) {
        for (RaungLabel label : this.labels) {
            if (label.getPos() != pos) continue;
            return label;
        }
        return null;
    }

    public List<RaungLabel> getLabels() {
        return this.labels;
    }

    public void setAnnotationForNextInsn(InsnAnnotationNode annotationNode) {
        this.insnAnnotationNode = annotationNode;
    }

    public InsnAnnotationNode getInsnAnnotationNode() {
        return this.insnAnnotationNode;
    }

    public void addTryCatchBlock(TryCatchBlock tryCatchBlock) {
        this.catchBlocks.add(tryCatchBlock);
    }

    public List<TryCatchBlock> getCatchBlocks() {
        return this.catchBlocks;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        return this.getAsmMethodVisitor().visitAnnotation(descriptor, visible);
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int ref, TypePath path, String descriptor, boolean visible) {
        return this.getAsmMethodVisitor().visitTypeAnnotation(ref, path, descriptor, visible);
    }
}

