/*
 * Decompiled with CFR 0.152.
 */
package io.github.skylot.raung.asm.impl.parser.directives;

import io.github.skylot.raung.asm.impl.parser.RaungParser;
import io.github.skylot.raung.asm.impl.parser.code.AnnotationParser;
import io.github.skylot.raung.asm.impl.parser.data.AutoOption;
import io.github.skylot.raung.asm.impl.parser.data.ClassData;
import io.github.skylot.raung.asm.impl.parser.data.FieldData;
import io.github.skylot.raung.asm.impl.parser.data.MethodData;
import io.github.skylot.raung.asm.impl.parser.directives.FieldDirectives;
import io.github.skylot.raung.asm.impl.parser.directives.IDirectivesProcessor;
import io.github.skylot.raung.asm.impl.parser.directives.MethodDirectives;
import io.github.skylot.raung.asm.impl.utils.RaungAsmException;
import io.github.skylot.raung.common.Directive;
import io.github.skylot.raung.common.RaungAccessFlags;
import java.util.EnumMap;
import java.util.Map;

public class ClassDirectives {
    private static final Map<Directive, IDirectivesProcessor<ClassData>> PROCESSOR_MAP;

    public static void process(Directive token, RaungParser parser, ClassData cw) {
        IDirectivesProcessor<ClassData> processor = PROCESSOR_MAP.get(token);
        if (processor == null) {
            throw new RaungAsmException("Unexpected class directive", token.token());
        }
        processor.process(parser, cw);
    }

    private static void processVersion(RaungParser parser, ClassData classData) {
        ClassDirectives.checkClassHeader(classData, Directive.VERSION);
        classData.setVersion(parser.readInt());
        parser.lineEnd();
    }

    private static void processClass(RaungParser parser, ClassData classData) {
        ClassDirectives.checkClassHeader(classData, Directive.CLASS);
        classData.setAccessFlags(parser.readAccessFlags(RaungAccessFlags.Scope.CLASS));
        classData.setName(parser.readToken());
        parser.lineEnd();
    }

    private static void processSuper(RaungParser parser, ClassData classData) {
        ClassDirectives.checkClassHeader(classData, Directive.SUPER);
        classData.setSuperCls(parser.readType());
        parser.lineEnd();
    }

    private static void processInterface(RaungParser parser, ClassData classData) {
        ClassDirectives.checkClassHeader(classData, Directive.INNERCLASS);
        classData.getInterfaces().add(parser.readType());
        parser.lineEnd();
    }

    private static void processSignature(RaungParser parser, ClassData classData) {
        ClassDirectives.checkClassHeader(classData, Directive.SIGNATURE);
        classData.setSignature(parser.readToken());
        parser.lineEnd();
    }

    private static void processSource(RaungParser parser, ClassData classData) {
        ClassDirectives.checkClassHeader(classData, Directive.SOURCE);
        classData.setSource(parser.readString());
        parser.lineEnd();
    }

    private static void processInnerClass(RaungParser parser, ClassData classData) {
        int accessFlags = parser.readAccessFlags(RaungAccessFlags.Scope.CLASS);
        String inner = parser.readToken();
        String outer = parser.readType();
        String name = parser.tryGetToken();
        if (name != null) {
            parser.lineEnd();
        } else {
            name = classData.getName();
        }
        classData.visitCls().visitInnerClass(name, outer, inner, accessFlags);
    }

    private static void processOuterClass(RaungParser parser, ClassData classData) {
        String owner = parser.readType();
        String name = parser.readToken();
        String descriptor = parser.readToken();
        classData.visitCls().visitOuterClass(owner, name, descriptor);
    }

    private static void processAuto(RaungParser parser, ClassData classData) {
        String token;
        ClassDirectives.checkClassHeader(classData, Directive.AUTO);
        switch (token = parser.readToken()) {
            case "disable": {
                classData.setAuto(AutoOption.DISABLE);
                break;
            }
            case "maxs": {
                classData.setAuto(AutoOption.MAXS);
                break;
            }
            case "frames": {
                classData.setAuto(AutoOption.FRAMES);
                break;
            }
            default: {
                throw new RaungAsmException("Unknown auto type: " + token + ", should be one of: 'disable', 'maxs' or 'frames'");
            }
        }
    }

    private static void checkClassHeader(ClassData classData, Directive directive) {
        if (classData.isVisited()) {
            throw new RaungAsmException(directive.token() + " directive should be placed before class body (i.e fields or methods)");
        }
    }

    private static void processNest(RaungParser parser, ClassData classData) {
        String ref;
        switch (ref = parser.readToken()) {
            case "host": {
                classData.visitCls().visitNestHost(parser.readType());
                break;
            }
            case "member": {
                classData.visitCls().visitNestMember(parser.readType());
                break;
            }
            default: {
                throw new RaungAsmException("Unknown nest ref type: '" + ref + "', expected 'host' or 'member'");
            }
        }
    }

    private static void processField(RaungParser parser, ClassData classData) {
        FieldData field = FieldDirectives.parseField(classData, parser);
        classData.getFields().add(field);
    }

    private static void processMethod(RaungParser parser, ClassData classData) {
        classData.visitCls();
        MethodData mth = MethodDirectives.parseMethod(classData, parser);
        classData.getMethods().add(mth);
    }

    static {
        EnumMap<Directive, IDirectivesProcessor<ClassData>> map = new EnumMap<Directive, IDirectivesProcessor<ClassData>>(Directive.class);
        map.put(Directive.VERSION, ClassDirectives::processVersion);
        map.put(Directive.CLASS, ClassDirectives::processClass);
        map.put(Directive.SUPER, ClassDirectives::processSuper);
        map.put(Directive.IMPLEMENTS, ClassDirectives::processInterface);
        map.put(Directive.SIGNATURE, ClassDirectives::processSignature);
        map.put(Directive.INNERCLASS, ClassDirectives::processInnerClass);
        map.put(Directive.OUTERCLASS, ClassDirectives::processOuterClass);
        map.put(Directive.NEST, ClassDirectives::processNest);
        map.put(Directive.SOURCE, ClassDirectives::processSource);
        map.put(Directive.AUTO, ClassDirectives::processAuto);
        map.put(Directive.FIELD, ClassDirectives::processField);
        map.put(Directive.METHOD, ClassDirectives::processMethod);
        map.put(Directive.ANNOTATION, AnnotationParser::process);
        map.put(Directive.TYPE_ANNOTATION, AnnotationParser::processTypeAnnotation);
        PROCESSOR_MAP = map;
    }
}

