/*
 * Decompiled with CFR 0.152.
 */
package io.github.skylot.raung.asm.impl.parser.directives;

import io.github.skylot.raung.asm.impl.parser.RaungParser;
import io.github.skylot.raung.asm.impl.parser.code.AnnotationParser;
import io.github.skylot.raung.asm.impl.parser.code.ValueParser;
import io.github.skylot.raung.asm.impl.parser.data.ClassData;
import io.github.skylot.raung.asm.impl.parser.data.FieldData;
import io.github.skylot.raung.asm.impl.parser.directives.IDirectivesProcessor;
import io.github.skylot.raung.asm.impl.utils.RaungAsmException;
import io.github.skylot.raung.common.Directive;
import io.github.skylot.raung.common.RaungAccessFlags;
import java.util.EnumMap;
import java.util.Map;

public class FieldDirectives {
    private static final Map<Directive, IDirectivesProcessor<FieldData>> PROCESSOR_MAP;

    public static FieldData parseField(ClassData classData, RaungParser parser) {
        FieldData field = new FieldData(classData);
        field.setAccessFlags(parser.readAccessFlags(RaungAccessFlags.Scope.FIELD));
        field.setName(parser.readToken());
        field.setType(parser.readType());
        String assign = parser.tryGetToken();
        if (assign != null) {
            if (!assign.equals("=")) {
                throw new RaungAsmException("Unexpected token after field definition", assign);
            }
            Object value = ValueParser.process(parser.readToken());
            field.setValue(value);
            parser.lineEnd();
        }
        FieldDirectives.parseDirectives(parser, field);
        field.getAsmVisitor().visitEnd();
        return field;
    }

    private static void parseDirectives(RaungParser parser, FieldData field) {
        Directive nextToken = Directive.parseToken((String)parser.peekToken());
        if (nextToken == null || !nextToken.isAllowedInField()) {
            return;
        }
        Directive directive;
        while ((directive = parser.readDirective()) != null) {
            if (directive == Directive.END) {
                parser.consumeToken("field");
                parser.lineEnd();
                return;
            }
            if (!directive.isAllowedInField()) {
                throw new RaungAsmException("Directive '" + directive.token() + "' not allowed in field scope");
            }
            FieldDirectives.process(directive, parser, field);
        }
        return;
    }

    private static void process(Directive token, RaungParser parser, FieldData cw) {
        IDirectivesProcessor<FieldData> processor = PROCESSOR_MAP.get(token);
        if (processor == null) {
            throw new RaungAsmException("Unexpected field directive", token.token());
        }
        processor.process(parser, cw);
    }

    private static void processSignature(RaungParser parser, FieldData field) {
        field.setSignature(parser.readToken());
        parser.lineEnd();
    }

    static {
        EnumMap<Directive, IDirectivesProcessor<FieldData>> map = new EnumMap<Directive, IDirectivesProcessor<FieldData>>(Directive.class);
        map.put(Directive.SIGNATURE, FieldDirectives::processSignature);
        map.put(Directive.ANNOTATION, AnnotationParser::process);
        map.put(Directive.TYPE_ANNOTATION, AnnotationParser::processTypeAnnotation);
        PROCESSOR_MAP = map;
    }
}

