/*
 * Decompiled with CFR 0.152.
 */
package io.github.skylot.raung.asm.impl.parser.utils;

import io.github.skylot.raung.common.RaungAccessFlags;
import java.util.HashMap;
import java.util.Map;

public class AccFlagsParser {
    private static final Map<String, AccFlagsInfo> FLAGS_MAP = new HashMap<String, AccFlagsInfo>(20);

    private static void add(String name, int accessFlag, RaungAccessFlags.Scope scope, RaungAccessFlags.Scope secondScope) {
        AccFlagsParser.add(name, new AccFlagsInfo(accessFlag, scope.getFlag() | secondScope.getFlag()));
    }

    private static void add(String name, int accessFlag, RaungAccessFlags.Scope scope) {
        AccFlagsParser.add(name, new AccFlagsInfo(accessFlag, scope.getFlag()));
    }

    private static void add(String name, AccFlagsInfo info) {
        FLAGS_MAP.put(name, info);
    }

    public static int parse(String token, RaungAccessFlags.Scope scope) {
        AccFlagsInfo info = FLAGS_MAP.get(token);
        if (info == null || (info.scopeFlags & scope.getFlag()) == 0) {
            return -1;
        }
        return info.accessFlag;
    }

    static {
        AccFlagsParser.add("public", 1, RaungAccessFlags.Scope.ANY);
        AccFlagsParser.add("private", 2, RaungAccessFlags.Scope.ANY);
        AccFlagsParser.add("protected", 4, RaungAccessFlags.Scope.ANY);
        AccFlagsParser.add("static", 8, RaungAccessFlags.Scope.ANY);
        AccFlagsParser.add("final", 16, RaungAccessFlags.Scope.ANY);
        AccFlagsParser.add("synthetic", 4096, RaungAccessFlags.Scope.ANY);
        AccFlagsParser.add("super", 32, RaungAccessFlags.Scope.CLASS);
        AccFlagsParser.add("interface", 512, RaungAccessFlags.Scope.CLASS);
        AccFlagsParser.add("annotation", 8192, RaungAccessFlags.Scope.CLASS);
        AccFlagsParser.add("module", 32768, RaungAccessFlags.Scope.CLASS);
        AccFlagsParser.add("enum", 16384, RaungAccessFlags.Scope.CLASS, RaungAccessFlags.Scope.FIELD);
        AccFlagsParser.add("abstract", 1024, RaungAccessFlags.Scope.CLASS, RaungAccessFlags.Scope.METHOD);
        AccFlagsParser.add("constructor", 65536, RaungAccessFlags.Scope.METHOD);
        AccFlagsParser.add("synchronized", 32, RaungAccessFlags.Scope.METHOD);
        AccFlagsParser.add("varargs", 128, RaungAccessFlags.Scope.METHOD);
        AccFlagsParser.add("bridge", 64, RaungAccessFlags.Scope.METHOD);
        AccFlagsParser.add("native", 256, RaungAccessFlags.Scope.METHOD);
        AccFlagsParser.add("strict", 2048, RaungAccessFlags.Scope.METHOD);
        AccFlagsParser.add("transient", 128, RaungAccessFlags.Scope.FIELD);
        AccFlagsParser.add("volatile", 64, RaungAccessFlags.Scope.FIELD);
    }

    private static final class AccFlagsInfo {
        int accessFlag;
        int scopeFlags;

        public AccFlagsInfo(int accessFlag, int scopeFlags) {
            this.accessFlag = accessFlag;
            this.scopeFlags = scopeFlags;
        }
    }
}

