/*
 * Decompiled with CFR 0.152.
 */
package io.github.skylot.raung.asm.impl.parser;

import io.github.skylot.raung.asm.impl.RaungAsmBuilder;
import io.github.skylot.raung.asm.impl.parser.RaungTokenizer;
import io.github.skylot.raung.asm.impl.parser.data.ClassData;
import io.github.skylot.raung.asm.impl.parser.directives.ClassDirectives;
import io.github.skylot.raung.asm.impl.parser.utils.AccFlagsParser;
import io.github.skylot.raung.asm.impl.utils.AsmLibException;
import io.github.skylot.raung.asm.impl.utils.RaungAsmException;
import io.github.skylot.raung.asm.impl.utils.RaungAsmTokenException;
import io.github.skylot.raung.common.Directive;
import io.github.skylot.raung.common.RaungAccessFlags;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RaungParser
implements Closeable {
    private final RaungAsmBuilder args;
    private final RaungTokenizer tokenizer;
    @Nullable
    private final String fileName;
    private final Queue<String> tokensAhead = new ArrayDeque<String>();

    public RaungParser(RaungAsmBuilder args, InputStream in, @Nullable String fileName) {
        this.args = args;
        this.tokenizer = new RaungTokenizer(Objects.requireNonNull(in));
        this.fileName = fileName;
    }

    public ClassData parse() {
        try {
            Directive directive;
            ClassData classData = new ClassData();
            while ((directive = this.readDirective()) != null) {
                ClassDirectives.process(directive, this, classData);
            }
            return classData;
        }
        catch (AsmLibException e) {
            throw new RaungAsmException(this.buildErrorMsg("Asm lib error", e, 0), e);
        }
        catch (RaungAsmTokenException e) {
            throw new RaungAsmException(this.buildErrorMsg("Parse error", e, e.getOffsetInToken()), e);
        }
        catch (Exception e) {
            throw new RaungAsmException(this.buildErrorMsg("Parse error", e, 0), e);
        }
    }

    @NotNull
    private String buildErrorMsg(String desc, Exception e, int offset) {
        return desc + "\n" + this.tokenizer.formatMsgForCurrentPosition(offset, e.getMessage(), this.fileName);
    }

    @Override
    public void close() throws IOException {
        this.tokenizer.close();
    }

    public RaungAsmBuilder getArgs() {
        return this.args;
    }

    private RaungTokenizer.TokenType consumeNext() {
        if (!this.tokensAhead.isEmpty()) {
            return RaungTokenizer.TokenType.TOKEN;
        }
        return this.tokenizer.next();
    }

    private String consumeToken() {
        if (!this.tokensAhead.isEmpty()) {
            return this.tokensAhead.poll();
        }
        return this.tokenizer.getToken();
    }

    private void pushTokenBack(String token) {
        this.tokensAhead.offer(token);
    }

    public void consumeToken(String expectedToken) {
        RaungTokenizer.TokenType tokenType = this.consumeNext();
        if (tokenType != RaungTokenizer.TokenType.TOKEN) {
            throw new RaungAsmException(String.format("Expected '%s', got '%s'", new Object[]{expectedToken, tokenType}));
        }
        String token = this.consumeToken();
        if (!token.equals(expectedToken)) {
            throw new RaungAsmException(String.format("Expected '%s' instead '%s'", expectedToken, token));
        }
    }

    public String tryGetToken() {
        if (this.consumeNext() == RaungTokenizer.TokenType.TOKEN) {
            return this.consumeToken();
        }
        return null;
    }

    public String peekToken() {
        String token = this.skipToToken();
        this.pushTokenBack(token);
        return token;
    }

    @Nullable
    public Directive readDirective() {
        String token = this.skipToToken();
        if (token == null) {
            return null;
        }
        Directive directive = Directive.parseToken((String)token);
        if (directive == null) {
            throw new RaungAsmException("Unknown directive", token);
        }
        return directive;
    }

    @Nullable
    public String skipToToken() {
        RaungTokenizer.TokenType tokenType;
        do {
            if ((tokenType = this.consumeNext()) != RaungTokenizer.TokenType.TOKEN) continue;
            return this.consumeToken();
        } while (tokenType != RaungTokenizer.TokenType.FILE_END);
        return null;
    }

    public String readToken() {
        RaungTokenizer.TokenType tokenType = this.consumeNext();
        if (tokenType == RaungTokenizer.TokenType.TOKEN) {
            return this.consumeToken();
        }
        throw new RaungAsmException("Expect token but got " + (Object)((Object)tokenType));
    }

    public String readType() {
        return this.readToken();
    }

    public int readInt() {
        String token = this.readToken();
        try {
            return Integer.parseInt(token);
        }
        catch (NumberFormatException e) {
            throw new RaungAsmException("Expect integer number but got", token);
        }
    }

    public String readString() {
        int last;
        String token = this.readToken();
        if (token.charAt(0) == '\"') {
            token = token.substring(1);
        }
        if (token.charAt(last = token.length() - 1) == '\"') {
            token = token.substring(0, last);
        }
        return token;
    }

    public int readAccessFlags(RaungAccessFlags.Scope scope) {
        String token;
        int accFlags = 0;
        while (true) {
            int flag;
            if ((flag = AccFlagsParser.parse(token = this.readToken(), scope)) == -1) break;
            accFlags |= flag;
        }
        this.pushTokenBack(token);
        return accFlags;
    }

    public void lineEnd() {
        if (this.consumeNext() == RaungTokenizer.TokenType.TOKEN) {
            throw new RaungAsmException("Unexpected token", this.consumeToken());
        }
    }
}

