/*
 * Decompiled with CFR 0.152.
 */
package io.github.skylot.raung.asm.impl.parser.code;

import io.github.skylot.raung.asm.impl.parser.RaungParser;
import io.github.skylot.raung.asm.impl.parser.code.ValueParser;
import io.github.skylot.raung.asm.impl.utils.RaungAsmException;
import io.github.skylot.raung.common.asm.HandleTag;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class InvokeDynamicParser {
    public static void parse(MethodVisitor mv, RaungParser parser) {
        ArrayList<Object> args;
        Handle handle;
        String descriptor;
        String name;
        block3: {
            String token;
            name = parser.readToken();
            descriptor = parser.readToken();
            handle = null;
            args = new ArrayList<Object>(3);
            while (true) {
                if ((token = parser.skipToToken()) == null) {
                    throw new RaungAsmException("Missing '.end invokedynamic' directive");
                }
                if (token.equals(".end")) break block3;
                if (token.equals(".handle")) {
                    handle = InvokeDynamicParser.parseHandle(parser);
                    continue;
                }
                if (!token.equals(".arg")) break;
                InvokeDynamicParser.parseArg(parser, args);
            }
            throw new RaungAsmException("Unexpected token for 'invokedynamic' scope", token);
        }
        parser.consumeToken("invokedynamic");
        mv.visitInvokeDynamicInsn(name, descriptor, handle, args.toArray(new Object[0]));
    }

    private static Handle parseHandle(RaungParser parser) {
        String tagStr = parser.readToken();
        HandleTag tag = HandleTag.getByName((String)tagStr);
        if (tag == null) {
            throw new RaungAsmException("Unknown handle tag", tagStr);
        }
        String owner = parser.readToken();
        String name = parser.readToken();
        String descriptor = parser.readToken();
        parser.lineEnd();
        boolean itf = tag == HandleTag.INVOKEINTERFACE;
        return new Handle(tag.getTag(), owner, name, descriptor, itf);
    }

    private static void parseArg(RaungParser parser, List<Object> args) {
        int index = parser.readInt();
        String token = parser.readToken();
        if (token.startsWith(".")) {
            switch (token) {
                case ".handle": {
                    args.add(index, InvokeDynamicParser.parseHandle(parser));
                    break;
                }
                case ".methodtype": {
                    args.add(index, InvokeDynamicParser.parseMethodType(parser));
                    break;
                }
                default: {
                    throw new RaungAsmException("Unknown directive for 'invokedynamic' scope", token);
                }
            }
        } else {
            args.add(ValueParser.process(token));
        }
    }

    private static Type parseMethodType(RaungParser parser) {
        return Type.getMethodType((String)parser.readToken());
    }
}

