/*
 * Decompiled with CFR 0.152.
 */
package io.github.skylot.raung.asm.impl.parser.directives;

import io.github.skylot.raung.asm.impl.parser.RaungParser;
import io.github.skylot.raung.asm.impl.parser.code.AnnotationParser;
import io.github.skylot.raung.asm.impl.parser.code.OpCodeParser;
import io.github.skylot.raung.asm.impl.parser.data.ClassData;
import io.github.skylot.raung.asm.impl.parser.data.MethodData;
import io.github.skylot.raung.asm.impl.parser.data.RaungLabel;
import io.github.skylot.raung.asm.impl.parser.data.RaungLocalVar;
import io.github.skylot.raung.asm.impl.parser.data.TryCatchBlock;
import io.github.skylot.raung.asm.impl.parser.directives.IDirectivesProcessor;
import io.github.skylot.raung.asm.impl.utils.AsmLibException;
import io.github.skylot.raung.asm.impl.utils.RaungAsmException;
import io.github.skylot.raung.common.Directive;
import io.github.skylot.raung.common.RaungAccessFlags;
import io.github.skylot.raung.common.asm.StackType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class MethodDirectives {
    private static final Map<Directive, IDirectivesProcessor<MethodData>> PROCESSOR_MAP;

    public static MethodData parseMethod(ClassData classData, RaungParser parser) {
        MethodData mth = new MethodData(classData);
        mth.setAccessFlags(parser.readAccessFlags(RaungAccessFlags.Scope.METHOD));
        String nameToken = parser.readToken();
        int argsStart = nameToken.indexOf(40);
        if (argsStart == -1) {
            throw new RaungAsmException("Incorrect method description", nameToken);
        }
        mth.setName(nameToken.substring(0, argsStart));
        mth.setDescriptor(nameToken.substring(argsStart));
        parser.lineEnd();
        block4: while (true) {
            String token;
            if ((token = parser.skipToToken()) == null) {
                throw new RaungAsmException("Unexpected method end");
            }
            switch (token.charAt(0)) {
                case '.': {
                    Directive directive = Directive.parseToken((String)token);
                    if (directive == null) {
                        throw new RaungAsmException("Unknown directive", token);
                    }
                    if (directive == Directive.END) {
                        if (!MethodDirectives.processEnd(mth, parser)) continue block4;
                        return mth;
                    }
                    MethodDirectives.process(directive, parser, mth);
                    continue block4;
                }
                case ':': {
                    MethodDirectives.processLabel(mth, parser, token);
                    continue block4;
                }
            }
            OpCodeParser.process(mth, mth.getAsmMethodVisitor(), parser, token);
        }
    }

    private static boolean processEnd(MethodData mth, RaungParser parser) {
        String token;
        switch (token = parser.readToken()) {
            case "local": {
                MethodDirectives.processLocalEnd(parser, mth);
                return false;
            }
            case "method": {
                MethodDirectives.processMethodEnd(mth);
                return true;
            }
        }
        throw new RaungAsmException("Unexpected token for .end", token);
    }

    private static void process(Directive token, RaungParser parser, MethodData methodData) {
        IDirectivesProcessor<MethodData> processor = PROCESSOR_MAP.get(token);
        if (processor == null) {
            throw new RaungAsmException("Not a method directive", token.token());
        }
        processor.process(parser, methodData);
    }

    private static void processThrows(RaungParser parser, MethodData methodData) {
        methodData.addThrow(parser.readType());
        parser.lineEnd();
    }

    private static void processSignature(RaungParser parser, MethodData methodData) {
        methodData.setSignature(parser.readToken());
        parser.lineEnd();
    }

    private static void processMax(RaungParser parser, MethodData methodData) {
        String type;
        switch (type = parser.readToken()) {
            case "stack": {
                methodData.setMaxStack(parser.readInt());
                break;
            }
            case "locals": {
                methodData.setMaxLocals(parser.readInt());
                break;
            }
            default: {
                throw new RaungAsmException("Unknown max type: '" + type + "'. Should be 'stack' or 'locals'");
            }
        }
        parser.lineEnd();
    }

    private static void processLocal(RaungParser parser, MethodData methodData) {
        int varNum = parser.readInt();
        String name = parser.readString();
        String type = parser.readToken();
        String signature = parser.tryGetToken();
        if (signature != null) {
            parser.lineEnd();
        }
        RaungLabel startLabel = MethodDirectives.attachLabel(methodData, null);
        methodData.addLocalVar(new RaungLocalVar(varNum, name, type, signature, startLabel));
    }

    private static void processLocalEnd(RaungParser parser, MethodData methodData) {
        int varNum = parser.readInt();
        parser.lineEnd();
        RaungLabel endLabel = MethodDirectives.attachLabel(methodData, null);
        RaungLocalVar localVar = methodData.getLocalVar(varNum);
        if (localVar == null) {
            throw new RaungAsmException("Unknown local variable with number: " + varNum);
        }
        MethodDirectives.visitLocalVar(methodData, localVar, endLabel);
    }

    private static void visitLocalVar(MethodData methodData, RaungLocalVar localVar, RaungLabel endLabel) {
        methodData.getAsmMethodVisitor().visitLocalVariable(localVar.getName(), localVar.getType(), localVar.getSignature(), (Label)localVar.getStartLabel(), (Label)endLabel, localVar.getNumber());
        localVar.setVisited(true);
    }

    private static void processLine(RaungParser parser, MethodData methodData) {
        int line = parser.readInt();
        methodData.getAsmMethodVisitor().visitLineNumber(line, (Label)MethodDirectives.attachLabel(methodData, null));
        parser.lineEnd();
    }

    private static void processLabel(MethodData mth, RaungParser parser, String labelName) {
        parser.lineEnd();
        RaungLabel existLabel = mth.getLabel(labelName);
        if (existLabel != null) {
            if (existLabel.getPos() != -1) {
                throw new RaungAsmException("Label already defined with name: " + labelName);
            }
            MethodDirectives.visitLabel(mth, existLabel);
        } else {
            MethodDirectives.attachLabel(mth, labelName);
        }
    }

    private static RaungLabel attachLabel(MethodData mth, @Nullable String name) {
        int pos = mth.getInsnsCount();
        RaungLabel existLabel = mth.getLabel(pos);
        if (existLabel != null) {
            return existLabel;
        }
        String labelName = name != null ? name : String.format("#L%d", pos);
        RaungLabel label = RaungLabel.makeNew(mth, labelName);
        return MethodDirectives.visitLabel(mth, label);
    }

    private static RaungLabel visitLabel(MethodData mth, RaungLabel label) {
        label.setPos(mth.getInsnsCount());
        mth.getAsmMethodVisitor().visitLabel((Label)label);
        return label;
    }

    private static void processMethodEnd(MethodData mth) {
        MethodVisitor mv = mth.getAsmMethodVisitor();
        MethodDirectives.visitTryCatchBlocks(mth);
        MethodDirectives.visitLocalVars(mth);
        try {
            mv.visitMaxs(mth.getMaxStack(), mth.getMaxLocals());
            mv.visitEnd();
        }
        catch (Exception e) {
            throw new AsmLibException("Failed to build method: " + mth.getName() + mth.getDescriptor() + ". Error: " + e.getMessage(), e);
        }
    }

    private static void visitTryCatchBlocks(MethodData mth) {
        List<TryCatchBlock> tryCatchBlocks = mth.getCatchBlocks();
        if (tryCatchBlocks.isEmpty()) {
            return;
        }
        Collections.sort(tryCatchBlocks);
        MethodVisitor visitor = mth.getAsmMethodVisitor();
        for (TryCatchBlock tcb : tryCatchBlocks) {
            visitor.visitTryCatchBlock((Label)tcb.getStart(), (Label)tcb.getEnd(), (Label)tcb.getHandler(), tcb.getType());
        }
    }

    private static void visitLocalVars(MethodData mth) {
        List notVisitedLocalVars = mth.getLocalVars().stream().filter(lv -> !lv.isVisited()).collect(Collectors.toList());
        if (notVisitedLocalVars.isEmpty()) {
            return;
        }
        RaungLabel endLabel = MethodDirectives.attachLabel(mth, null);
        for (RaungLocalVar localVar : notVisitedLocalVars) {
            if (localVar.isVisited()) continue;
            MethodDirectives.visitLocalVar(mth, localVar, endLabel);
        }
    }

    private static void processStack(RaungParser parser, MethodData methodData) {
        String type = parser.readToken();
        MethodVisitor mv = methodData.getAsmMethodVisitor();
        switch (type) {
            case "same": {
                mv.visitFrame(3, 0, null, 0, null);
                break;
            }
            case "same1": {
                Object value = MethodDirectives.parseStackType(parser.readToken(), parser, methodData);
                mv.visitFrame(4, 0, null, 1, new Object[]{value});
                break;
            }
            case "chop": {
                mv.visitFrame(2, parser.readInt(), null, 0, null);
                break;
            }
            case "append": {
                parser.lineEnd();
                ArrayList<Object> locals = new ArrayList<Object>();
                while (true) {
                    String token;
                    if ((token = parser.skipToToken()) == null) {
                        throw new RaungAsmException("Unexpected end of .stack directive");
                    }
                    if (token.equals(".end")) break;
                    locals.add(MethodDirectives.parseStackType(token, parser, methodData));
                }
                parser.consumeToken("stack");
                mv.visitFrame(1, locals.size(), locals.toArray(new Object[0]), 0, null);
                break;
            }
            case "full": {
                MethodDirectives.parseCompleteFrame(0, parser, methodData, mv);
                break;
            }
            case "new": {
                MethodDirectives.parseCompleteFrame(-1, parser, methodData, mv);
                break;
            }
            default: {
                throw new RaungAsmException("Unexpected stack type: " + type);
            }
        }
        parser.lineEnd();
    }

    private static void parseCompleteFrame(int frameType, RaungParser parser, MethodData methodData, MethodVisitor mv) {
        parser.lineEnd();
        ArrayList<Object> locals = new ArrayList<Object>();
        ArrayList<Object> stack = new ArrayList<Object>();
        while (true) {
            String token;
            if ((token = parser.skipToToken()) == null) {
                throw new RaungAsmException("Unexpected end of .stack directive");
            }
            if (token.equals(".end")) break;
            switch (token) {
                case "local": {
                    parser.readInt();
                    locals.add(MethodDirectives.parseStackType(parser.readToken(), parser, methodData));
                    break;
                }
                case "stack": {
                    parser.readInt();
                    stack.add(MethodDirectives.parseStackType(parser.readToken(), parser, methodData));
                }
            }
            parser.lineEnd();
        }
        parser.consumeToken("stack");
        mv.visitFrame(frameType, locals.size(), locals.toArray(new Object[0]), stack.size(), stack.toArray(new Object[0]));
    }

    private static Object parseStackType(String token, RaungParser parser, MethodData methodData) {
        StackType type = StackType.getByName((String)token);
        if (type != null) {
            return type.getValue();
        }
        if (token.equals("Uninitialized")) {
            String label = parser.readToken();
            return RaungLabel.ref(methodData, label);
        }
        return token;
    }

    private static void processCatch(RaungParser parser, MethodData methodData) {
        String typeStr;
        int id;
        String token = parser.readToken();
        if (token.startsWith("@")) {
            id = Integer.parseInt(token.substring(1));
            typeStr = parser.readType();
        } else {
            id = Integer.MAX_VALUE;
            typeStr = token;
        }
        RaungLabel startLabel = RaungLabel.ref(methodData, parser.readToken());
        parser.consumeToken("..");
        RaungLabel endLabel = RaungLabel.ref(methodData, parser.readToken());
        parser.consumeToken("goto");
        RaungLabel handlerLabel = RaungLabel.ref(methodData, parser.readToken());
        String type = typeStr.equals("all") ? null : typeStr;
        methodData.addTryCatchBlock(new TryCatchBlock(id, startLabel, endLabel, handlerLabel, type));
    }

    static {
        EnumMap<Directive, IDirectivesProcessor<MethodData>> map = new EnumMap<Directive, IDirectivesProcessor<MethodData>>(Directive.class);
        map.put(Directive.THROW, MethodDirectives::processThrows);
        map.put(Directive.SIGNATURE, MethodDirectives::processSignature);
        map.put(Directive.MAX, MethodDirectives::processMax);
        map.put(Directive.LINE, MethodDirectives::processLine);
        map.put(Directive.LOCAL, MethodDirectives::processLocal);
        map.put(Directive.STACK, MethodDirectives::processStack);
        map.put(Directive.CATCH, MethodDirectives::processCatch);
        map.put(Directive.ANNOTATION, AnnotationParser::process);
        map.put(Directive.TYPE_ANNOTATION, AnnotationParser::processTypeAnnotation);
        map.put(Directive.PARAM_ANNOTATION, AnnotationParser::processParamAnnotation);
        map.put(Directive.INSN_ANNOTATION, AnnotationParser::processInsnAnnotation);
        map.put(Directive.ANNOTATION_DEFAULT_VALUE, AnnotationParser::processAnnotationDefaultValue);
        PROCESSOR_MAP = map;
    }
}

