/*
 * Decompiled with CFR 0.152.
 */
package io.github.skylot.raung.asm.impl.parser.utils;

import io.github.skylot.raung.asm.impl.utils.RaungAsmTokenException;

public class StringAsmUtils {
    public static String unescapeString(String str) {
        int len = str.length();
        if (len == 0) {
            return "";
        }
        if (str.indexOf(92) == -1) {
            return str;
        }
        StringBuilder sb = new StringBuilder();
        boolean escape = false;
        int offset = 0;
        while (offset < len) {
            int codePoint = str.codePointAt(offset);
            if (escape) {
                escape = false;
                if (codePoint == 117) {
                    offset += StringAsmUtils.processUnicodeChar(str, offset, len, sb);
                    continue;
                }
                char c = StringAsmUtils.processSingleChar(codePoint);
                if (c == '\u0000') {
                    String ch = new StringBuilder().appendCodePoint(codePoint).toString();
                    throw new RaungAsmTokenException("Unexpected escape for char: " + ch, offset + 1);
                }
                sb.append(c);
                ++offset;
                continue;
            }
            if (codePoint == 92) {
                escape = true;
                ++offset;
                continue;
            }
            sb.appendCodePoint(codePoint);
            offset += Character.charCount(codePoint);
        }
        return sb.toString();
    }

    private static char processSingleChar(int codePoint) {
        switch (codePoint) {
            case 110: {
                return '\n';
            }
            case 114: {
                return '\r';
            }
            case 116: {
                return '\t';
            }
            case 98: {
                return '\b';
            }
            case 102: {
                return '\f';
            }
            case 39: {
                return '\'';
            }
            case 34: {
                return '\"';
            }
            case 92: {
                return '\\';
            }
        }
        return '\u0000';
    }

    private static int processUnicodeChar(String str, int offset, int len, StringBuilder sb) {
        int start = offset + 1;
        if (start + 4 > len) {
            throw new RaungAsmTokenException("Truncated unicode sequence", start);
        }
        String unicodeIdStr = str.substring(start, start + 4);
        try {
            int unicodeCodePoint = Integer.parseInt(unicodeIdStr, 16);
            sb.appendCodePoint(unicodeCodePoint);
            return 5;
        }
        catch (NumberFormatException e) {
            throw new RaungAsmTokenException("Malformed unicode number: " + unicodeIdStr, start + 1);
        }
    }
}

