/*
 * Decompiled with CFR 0.152.
 */
package io.github.skylot.raung.asm.impl.utils;

import io.github.skylot.raung.asm.impl.RaungAsmBuilder;
import io.github.skylot.raung.asm.impl.utils.RaungAsmException;
import io.github.skylot.raung.common.utils.FileUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateAsmArgs {
    private static final Logger LOG = LoggerFactory.getLogger(ValidateAsmArgs.class);

    public static void process(RaungAsmBuilder args) {
        if (args.getInputs().isEmpty()) {
            throw new RaungAsmException("Empty inputs");
        }
        for (Path input : args.getInputs()) {
            if (Files.exists(input, new LinkOption[0])) continue;
            throw new RaungAsmException("Input not found: " + input.toAbsolutePath());
        }
        Path output = args.getOutput();
        if (output == null) {
            args.output(ValidateAsmArgs.getOutDirFromInputs(args.getInputs()));
        }
        ValidateAsmArgs.processOptions(args);
    }

    public static void processOptions(RaungAsmBuilder args) {
        LOG.debug("Effective args: {}", (Object)args);
    }

    private static Path getOutDirFromInputs(List<Path> inputs) {
        String fileName;
        Path input = inputs.get(0);
        Path parent = FileUtils.getParentDir((Path)input);
        Path candidate = parent.resolve((fileName = input.getFileName().toString()) + ".jar");
        if (!Files.exists(candidate, new LinkOption[0])) {
            return candidate;
        }
        return parent.resolve(fileName + "-raung.jar");
    }
}

