/*
 * Decompiled with CFR 0.152.
 */
package io.github.skylot.raung.disasm.impl.utils;

import io.github.skylot.raung.common.Directive;

public class RaungWriter {
    public static final String NL = System.lineSeparator();
    public static final String INDENT_STR = "  ";
    private final StringBuilder sb = new StringBuilder();
    private String indentStr = "";
    private int indent = 0;

    public RaungWriter newLine() {
        this.sb.append(NL);
        return this;
    }

    public RaungWriter startLine() {
        this.sb.append(NL);
        this.sb.append(this.indentStr);
        return this;
    }

    public RaungWriter startLine(String line) {
        this.startLine();
        this.sb.append(line);
        return this;
    }

    public RaungWriter startLine(Directive directive) {
        this.startLine();
        this.add(directive);
        return this;
    }

    public RaungWriter add(Directive directive) {
        this.sb.append(directive.token());
        this.sb.append(' ');
        return this;
    }

    public RaungWriter add(String str) {
        this.sb.append(str);
        return this;
    }

    public RaungWriter addString(String str) {
        this.sb.append('\"');
        this.sb.append(str);
        this.sb.append('\"');
        return this;
    }

    public RaungWriter add(int number) {
        this.sb.append(number);
        return this;
    }

    public RaungWriter add(char ch) {
        this.sb.append(ch);
        return this;
    }

    public RaungWriter space() {
        this.sb.append(' ');
        return this;
    }

    public void add(RaungWriter rw) {
        this.sb.append(rw.getCode());
    }

    public int getIndent() {
        return this.indent;
    }

    public RaungWriter setIndent(int indentValue) {
        this.indent = indentValue;
        this.indentStr = this.buildIndentStr();
        return this;
    }

    public RaungWriter increaseIndent() {
        ++this.indent;
        this.indentStr = this.buildIndentStr();
        return this;
    }

    public RaungWriter decreaseIndent() {
        --this.indent;
        this.indentStr = this.buildIndentStr();
        return this;
    }

    private String buildIndentStr() {
        switch (this.indent) {
            case 0: {
                return "";
            }
            case 1: {
                return INDENT_STR;
            }
            case 2: {
                return "    ";
            }
        }
        StringBuilder indSb = new StringBuilder(INDENT_STR.length() * this.indent);
        for (int i = 0; i < this.indent; ++i) {
            indSb.append(INDENT_STR);
        }
        return indSb.toString();
    }

    public RaungWriter clear() {
        this.sb.setLength(0);
        return this;
    }

    public String getCode() {
        return this.sb.toString();
    }

    public String toString() {
        return this.getCode();
    }
}

