/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.smartboot.http.common.enums.HttpStatus;
import org.smartboot.http.common.exception.HttpException;
import org.smartboot.http.common.utils.SmartDecoder;

public class ChunkedFrameDecoder
implements SmartDecoder {
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream(8);
    private boolean readChunkedLengthFlag = true;
    private int remainingThreshold = -1;
    private int chunkedSize = -1;

    @Override
    public boolean decode(ByteBuffer byteBuffer) {
        this.readChunkedLength(byteBuffer);
        if (this.chunkedSize < 0) {
            return false;
        }
        int remaining = byteBuffer.remaining();
        if (remaining == 0) {
            return false;
        }
        if (this.remainingThreshold == 0) {
            if (remaining < 2) {
                return false;
            }
            this.readCrlf(byteBuffer);
            if (this.chunkedSize == 0) {
                return true;
            }
            this.chunkedSize = -1;
            this.readChunkedLengthFlag = true;
            return this.decode(byteBuffer);
        }
        int readSize = Math.min(byteBuffer.remaining(), this.remainingThreshold);
        byte[] bytes = new byte[readSize];
        byteBuffer.get(bytes);
        try {
            this.buffer.write(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.remainingThreshold -= readSize;
        return this.decode(byteBuffer);
    }

    @Override
    public ByteBuffer getBuffer() {
        return ByteBuffer.wrap(this.buffer.toByteArray());
    }

    private void readChunkedLength(ByteBuffer byteBuffer) {
        byteBuffer.mark();
        while (this.readChunkedLengthFlag && byteBuffer.remaining() > 2) {
            if (byteBuffer.get() != 13) continue;
            if (byteBuffer.get() != 10) {
                throw new HttpException(HttpStatus.BAD_REQUEST);
            }
            int position = byteBuffer.position();
            byteBuffer.reset();
            byte[] bytes = new byte[position - byteBuffer.position() - 2];
            byteBuffer.get(bytes);
            byteBuffer.position(position);
            this.remainingThreshold = this.chunkedSize = Integer.parseInt(new String(bytes), 16);
            this.readChunkedLengthFlag = false;
        }
        if (this.chunkedSize < 0) {
            byteBuffer.reset();
            return;
        }
        byteBuffer.mark();
    }

    private void readCrlf(ByteBuffer buffer) {
        if (buffer.get() != 13) {
            throw new HttpException(HttpStatus.BAD_REQUEST);
        }
        if (buffer.get() != 10) {
            throw new HttpException(HttpStatus.BAD_REQUEST);
        }
    }
}

