/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.smartboot.http.common.utils.DateUtils;

public class Cookie {
    private static final String TSPECIALS;
    private static final String DOMAIN = "Domain";
    private static final String MAX_AGE = "Max-Age";
    private static final String PATH = "Path";
    private static final String SECURE = "Secure";
    private static final String HTTP_ONLY = "HttpOnly";
    private static final String EMPTY_STRING = "";
    private final String name;
    private String value;
    private Map<String, String> attributes = null;

    public Cookie(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public Cookie(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public Cookie setValue(String value) {
        this.value = value;
        return this;
    }

    public String getPath() {
        return this.getAttribute(PATH);
    }

    public void setPath(String uri) {
        this.putAttribute(PATH, uri);
    }

    public String getDomain() {
        return this.getAttribute(DOMAIN);
    }

    public String getAttribute(String name) {
        return this.attributes == null ? null : this.attributes.get(name);
    }

    public void setDomain(String domain) {
        this.putAttribute(DOMAIN, domain != null ? domain.toLowerCase(Locale.ENGLISH) : null);
    }

    public void setAttribute(String name, String value) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name is blank");
        }
        if (Cookie.hasReservedCharacters(name)) {
            throw new IllegalArgumentException("name is invalid");
        }
        if (MAX_AGE.equalsIgnoreCase(name) && value != null) {
            this.setMaxAge(Integer.parseInt(value));
        } else {
            this.putAttribute(name, value);
        }
    }

    private static boolean hasReservedCharacters(String value) {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c >= ' ' && c < '\u007f' && TSPECIALS.indexOf(c) == -1) continue;
            return true;
        }
        return false;
    }

    private void putAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        }
        if (value == null) {
            this.attributes.remove(name);
        } else {
            this.attributes.put(name, value);
        }
    }

    public int getMaxAge() {
        String maxAge = this.getAttribute(MAX_AGE);
        return maxAge == null ? -1 : Integer.parseInt(maxAge);
    }

    public void setMaxAge(int expiry) {
        this.putAttribute(MAX_AGE, expiry < 0 ? null : String.valueOf(expiry));
    }

    public boolean isSecure() {
        return EMPTY_STRING.equals(this.getAttribute(SECURE));
    }

    public void setSecure(boolean flag) {
        if (flag) {
            this.putAttribute(SECURE, EMPTY_STRING);
        } else {
            this.putAttribute(SECURE, null);
        }
    }

    public boolean isHttpOnly() {
        return EMPTY_STRING.equals(this.getAttribute(HTTP_ONLY));
    }

    public void setHttpOnly(boolean httpOnly) {
        if (httpOnly) {
            this.putAttribute(HTTP_ONLY, EMPTY_STRING);
        } else {
            this.putAttribute(HTTP_ONLY, null);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append('=').append(this.getValue());
        if (this.attributes != null) {
            sb.append(";");
            this.attributes.forEach((key, val) -> {
                if (MAX_AGE.equals(key)) {
                    int maxAge = this.getMaxAge();
                    if (maxAge >= 0) {
                        sb.append("Max-Age=").append(maxAge).append(";");
                        Date expires = new Date();
                        if (maxAge == 0) {
                            expires.setTime(0L);
                        } else {
                            expires.setTime(expires.getTime() + (long)maxAge * 1000L);
                        }
                        sb.append("Expires=").append(DateUtils.formatCookieExpire(expires)).append(";");
                    }
                    return;
                }
                sb.append((String)key);
                if (!EMPTY_STRING.equals(val)) {
                    sb.append("=").append((String)val);
                }
                sb.append(";");
            });
        }
        return sb.toString();
    }

    static {
        boolean enforced = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.valueOf(System.getProperty("org.glassfish.web.rfc2109_cookie_names_enforced", "true"));
            }
        });
        TSPECIALS = enforced ? "/()<>@,;:\\\"[]?={} \t" : ",; ";
    }
}

