/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.smartboot.http.common.enums.HttpStatus;
import org.smartboot.http.common.exception.HttpException;
import org.smartboot.http.common.io.AbstractInputStream;
import org.smartboot.socket.transport.AioSession;

public class ChunkedInputStream
extends AbstractInputStream {
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream(8);
    private Map<String, String> trailerFields;
    private int remainingThreshold;
    private final Consumer<Map<String, String>> consumer;
    private String trailerName;
    private int chunkedRemaining;

    public ChunkedInputStream(AioSession session, int maxPayload, Consumer<Map<String, String>> consumer) {
        super(session);
        this.remainingThreshold = maxPayload;
        this.consumer = consumer;
    }

    @Override
    public int read() throws IOException {
        this.readChunkedLength();
        if (this.eof) {
            return -1;
        }
        if (this.chunkedRemaining > 0) {
            --this.chunkedRemaining;
            return this.readByte();
        }
        this.readCrlf();
        this.readFlag = true;
        return this.read();
    }

    @Override
    public int read(byte[] data, int off, int len) throws IOException {
        this.readChunkedLength();
        if (this.eof) {
            return -1;
        }
        if (len == 0) {
            return 0;
        }
        ByteBuffer byteBuffer = this.session.readBuffer();
        if (this.chunkedRemaining > 0 && !byteBuffer.hasRemaining()) {
            this.session.read();
        }
        int readLength = Math.min(len, byteBuffer.remaining());
        readLength = Math.min(readLength, this.chunkedRemaining);
        byteBuffer.get(data, off, readLength);
        this.chunkedRemaining -= readLength;
        if (this.chunkedRemaining > 0) {
            return readLength + this.read(data, off + readLength, len - readLength);
        }
        this.readCrlf();
        this.readFlag = true;
        this.readChunkedLength();
        if (this.eof) {
            return readLength;
        }
        return readLength + this.read(data, off + readLength, len - readLength);
    }

    private void readChunkedLength() throws IOException {
        while (this.readFlag) {
            byte b = this.readByte();
            if (b == 10) {
                this.chunkedRemaining = Integer.parseInt(this.buffer.toString(), 16);
                this.remainingThreshold = this.remainingThreshold - 2 - this.buffer.size() - this.chunkedRemaining;
                if (this.remainingThreshold < 0) {
                    throw new HttpException(HttpStatus.PAYLOAD_TOO_LARGE);
                }
                this.buffer.reset();
                this.readFlag = false;
                if (this.chunkedRemaining != 0) continue;
                this.eof = true;
                this.parseTrailerFields();
                break;
            }
            if (b == 13) continue;
            this.buffer.write(b);
        }
    }

    private void readCrlf() throws IOException {
        if (this.readByte() != 13) {
            throw new HttpException(HttpStatus.BAD_REQUEST);
        }
        if (this.readByte() != 10) {
            throw new HttpException(HttpStatus.BAD_REQUEST);
        }
    }

    private void parseTrailerFields() throws IOException {
        while (true) {
            byte b;
            if ((b = this.readByte()) == 10) {
                if (this.buffer.size() == 0) {
                    this.consumer.accept(this.trailerFields);
                    return;
                }
                this.trailerFields.put(this.trailerName, this.buffer.toString());
                this.buffer.reset();
                continue;
            }
            if (b == 58) {
                this.trailerName = this.buffer.toString();
                this.buffer.reset();
                continue;
            }
            if (b == 13) continue;
            if (this.trailerFields == null) {
                this.trailerFields = new HashMap<String, String>();
            }
            this.buffer.write(b);
        }
    }
}

