/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.smartboot.http.common.io.AbstractInputStream;
import org.smartboot.socket.transport.AioSession;

public class PostInputStream
extends AbstractInputStream {
    private long remaining;

    public PostInputStream(AioSession session, long contentLength) {
        super(session);
        this.remaining = contentLength;
    }

    @Override
    public int read(byte[] data, int off, int len) throws IOException {
        int readLength;
        if (this.eof) {
            return -1;
        }
        if (len == 0) {
            return 0;
        }
        ByteBuffer byteBuffer = this.session.readBuffer();
        if (this.remaining > 0L && !byteBuffer.hasRemaining()) {
            this.session.read();
        }
        if (this.remaining < (long)(readLength = Math.min(len, byteBuffer.remaining()))) {
            readLength = (int)this.remaining;
        }
        byteBuffer.get(data, off, readLength);
        this.remaining -= (long)readLength;
        if (this.remaining > 0L) {
            return readLength + this.read(data, off + readLength, len - readLength);
        }
        this.eof = true;
        return readLength;
    }

    @Override
    public int available() {
        return Math.min((int)this.remaining, this.session.readBuffer().remaining());
    }

    @Override
    public int read() throws IOException {
        if (this.eof) {
            return -1;
        }
        --this.remaining;
        this.eof = this.remaining == 0L;
        return this.readByte();
    }
}

