/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common.codec.h2.hpack;

import java.nio.ByteBuffer;

public final class HPACK {
    private HPACK() {
    }

    public static int read(ByteBuffer source, long buffer, int bufferLen, BufferUpdateConsumer consumer) {
        int nBytes = Math.min(64 - bufferLen >> 3, source.remaining());
        switch (nBytes) {
            case 0: {
                break;
            }
            case 3: {
                buffer |= ((long)source.get() & 0xFFL) << 56 - bufferLen;
                bufferLen += 8;
            }
            case 2: {
                buffer |= ((long)source.get() & 0xFFL) << 56 - bufferLen;
                bufferLen += 8;
            }
            case 1: {
                buffer |= ((long)source.get() & 0xFFL) << 56 - bufferLen;
                consumer.accept(buffer, bufferLen += 8);
                break;
            }
            case 7: {
                buffer |= ((long)source.get() & 0xFFL) << 56 - bufferLen;
                bufferLen += 8;
            }
            case 6: {
                buffer |= ((long)source.get() & 0xFFL) << 56 - bufferLen;
                bufferLen += 8;
            }
            case 5: {
                buffer |= ((long)source.get() & 0xFFL) << 56 - bufferLen;
                bufferLen += 8;
            }
            case 4: {
                buffer |= ((long)source.getInt() & 0xFFFFFFFFL) << 32 - bufferLen;
                consumer.accept(buffer, bufferLen += 32);
                break;
            }
            case 8: {
                buffer = source.getLong();
                bufferLen = 64;
                consumer.accept(buffer, bufferLen);
                break;
            }
            default: {
                throw new InternalError(String.valueOf(nBytes));
            }
        }
        return nBytes;
    }

    public static int write(long buffer, int bufferLen, BufferUpdateConsumer consumer, ByteBuffer destination) {
        int nBytes = Math.min(bufferLen >> 3, destination.remaining());
        switch (nBytes) {
            case 0: {
                break;
            }
            case 3: {
                destination.put((byte)(buffer >>> 56));
                buffer <<= 8;
                bufferLen -= 8;
            }
            case 2: {
                destination.put((byte)(buffer >>> 56));
                buffer <<= 8;
                bufferLen -= 8;
            }
            case 1: {
                destination.put((byte)(buffer >>> 56));
                consumer.accept(buffer <<= 8, bufferLen -= 8);
                break;
            }
            case 7: {
                destination.put((byte)(buffer >>> 56));
                buffer <<= 8;
                bufferLen -= 8;
            }
            case 6: {
                destination.put((byte)(buffer >>> 56));
                buffer <<= 8;
                bufferLen -= 8;
            }
            case 5: {
                destination.put((byte)(buffer >>> 56));
                buffer <<= 8;
                bufferLen -= 8;
            }
            case 4: {
                destination.putInt((int)(buffer >>> 32));
                consumer.accept(buffer <<= 32, bufferLen -= 32);
                break;
            }
            case 8: {
                destination.putLong(buffer);
                buffer = 0L;
                bufferLen = 0;
                consumer.accept(buffer, bufferLen);
                break;
            }
            default: {
                throw new InternalError(String.valueOf(nBytes));
            }
        }
        return nBytes;
    }

    static int bytesForBits(int n) {
        assert (n / 8 + (n % 8 != 0 ? 1 : 0) == (n + 7) / 8 && (n + 7) / 8 == n + 7 >> 3) : n;
        return n + 7 >> 3;
    }

    @FunctionalInterface
    static interface BufferUpdateConsumer {
        public void accept(long var1, int var3);
    }
}

