/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common.codec.h2.hpack;

import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.smartboot.http.common.codec.h2.hpack.SimpleHeaderTable;

final class HeaderTable
extends SimpleHeaderTable {
    private static final Map<String, Map<String, Integer>> staticIndexes;
    private final Map<String, Map<String, Deque<Long>>> map = new HashMap<String, Map<String, Deque<Long>>>();
    private long counter = 1L;

    public HeaderTable(int maxSize) {
        super(maxSize);
    }

    public int indexOf(CharSequence name, CharSequence value) {
        Integer idx;
        String n = name.toString();
        String v = value.toString();
        Map<String, Integer> values = staticIndexes.get(n);
        if (values != null && (idx = values.get(v)) != null) {
            return idx;
        }
        int didx = this.search(n, v);
        if (didx > 0) {
            return STATIC_TABLE_LENGTH + didx;
        }
        if (didx < 0) {
            if (values != null) {
                return -values.values().iterator().next().intValue();
            }
            return -STATIC_TABLE_LENGTH + didx;
        }
        if (values != null) {
            return -values.values().iterator().next().intValue();
        }
        return 0;
    }

    @Override
    protected void add(SimpleHeaderTable.HeaderField f) {
        super.add(f);
        Map values = this.map.computeIfAbsent(f.name, k -> new HashMap());
        Deque indexes = values.computeIfAbsent(f.value, k -> new LinkedList());
        long counterSnapshot = this.counter++;
        indexes.add(counterSnapshot);
        assert (this.indexesUniqueAndOrdered(indexes));
    }

    private boolean indexesUniqueAndOrdered(Deque<Long> indexes) {
        long maxIndexSoFar = -1L;
        for (long l : indexes) {
            if (l <= maxIndexSoFar) {
                return false;
            }
            maxIndexSoFar = l;
        }
        return true;
    }

    int search(String name, String value) {
        Map<String, Deque<Long>> values = this.map.get(name);
        if (values == null) {
            return 0;
        }
        Deque<Long> indexes = values.get(value);
        if (indexes != null) {
            return (int)(this.counter - indexes.peekLast());
        }
        assert (!values.isEmpty());
        Long any = values.values().iterator().next().peekLast();
        return -((int)(this.counter - any));
    }

    @Override
    protected SimpleHeaderTable.HeaderField remove() {
        SimpleHeaderTable.HeaderField f = super.remove();
        Map<String, Deque<Long>> values = this.map.get(f.name);
        Deque<Long> indexes = values.get(f.value);
        Long index = indexes.pollFirst();
        if (indexes.isEmpty()) {
            values.remove(f.value);
        }
        assert (index != null);
        if (values.isEmpty()) {
            this.map.remove(f.name);
        }
        return f;
    }

    static {
        HashMap<String, Map> map = new HashMap<String, Map>(STATIC_TABLE_LENGTH);
        for (int i = 1; i <= STATIC_TABLE_LENGTH; ++i) {
            SimpleHeaderTable.HeaderField f = (SimpleHeaderTable.HeaderField)staticTable.get(i);
            Map values = map.computeIfAbsent(f.name, k -> new HashMap());
            values.put(f.value, i);
        }
        HashMap copy = new HashMap(map.size());
        for (Map.Entry e : map.entrySet()) {
            copy.put(e.getKey(), new HashMap((Map)e.getValue()));
        }
        staticIndexes = new HashMap<String, Map<String, Integer>>(copy);
    }
}

